<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINAC_Elementor_Posts $this */

$blog_archive_url = get_post_type_archive_link('post');

$query_args = [
    'post_type' => 'post',
    'posts_per_page' => $this->posts_count,
    'orderby' => $this->post_order,
    'cat' => $this->post_category,
];
$posts_query = new \WP_Query($query_args);
$unique_id = uniqid($this->style_option .'-');

?>
<div class="blg-widget-padding-y">
    <div class="w-full my-8">
        <div class="flex justify-between items-center blog-post-title">
            <div class="flex flex-col gap-y-2">
                <h3 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php echo esc_html($this->main_title); ?></h3>
                <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                    <div class="h-[3px] blg-title-underline rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                </div>
            </div>
            <?php if ($this->show_buttons) : ?>
                <div class="lg:flex hidden gap-x-2 items-center">
                    <a href="<?php echo esc_url($blog_archive_url); ?>" aria-label="view all" class="blg-btn-secondary">
                        <?php echo $this->button_text; ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <?php if ($posts_query->have_posts()) : ?>

    <div class="grid xl:grid-cols-5 grid-cols-1 gap-y-6 xl:gap-x-6">

        <?php
        $post_count = 0; // Counter to track the number of posts rendered
        while ($posts_query->have_posts()) : $posts_query->the_post();
            $post_count++;
            ?>

            <?php if ($post_count === 1) : ?>
                <!-- Column for the first (main) post -->
                <div class="col-span-3 h-full max-md:hidden">
                    <div class="blg-shadow-sm blog-post-card flex flex-col gap-y-5 rounded-3xl bg-white py-6 px-6 h-full">
                        <div class="flex flex-col gap-y-3">
                            <a href="<?php the_permalink(); ?>" class="w-full rounded-[20px]">
                                <?php if (has_post_thumbnail()) : ?>
                                    <img width="100%" height="300" class="!rounded-[20px] w-full max-h-[300px] h-[300px] object-cover" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title_attribute(); ?>">
                                <?php else : ?>
                                    <img width="100%" height="300" class="!rounded-[20px] w-full max-h-[300px] h-[300px] object-cover" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="Default Image">
                                <?php endif; ?>
                            </a>

                            <?php if ($this->show_tag) :
                                $categories = get_the_category();
                                if (!empty($categories)) :
                                    $first_category = $categories[0];
                                    $category_name = $first_category->name;
                                    $category_link = get_category_link($first_category->term_id);
                                    ?>
                                    <a class="bg-[#78818D] text-white rounded text-xs font-normal text-nowrap max-w-max px-4 text-center py-[10px]" href="<?php echo esc_url($category_link); ?>">
                                        <?php echo esc_html($category_name); ?>
                                    </a>
                                <?php endif; endif; ?>

                            <div class="flex gap-x-1 items-center justify-between">
                                <a href="<?php the_permalink(); ?>" target="_blank" title="<?php the_title(); ?>">
                                    <div class="flex gap-x-1 items-center">
                                        <svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
                                            <circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
                                        </svg>
                                        <h4 class="md:text-base text-[13px] font-bold text-[var(--blg-color-primary500)]"><?php the_title(); ?></h4>
                                    </div>
                                </a>
                                <?php if ($this->show_time) : ?>
                                    <div class="flex items-center gap-x-[2px]">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                                            <path d="M10.2698 18.4154C14.2537 18.4154 17.4834 15.1806 17.4834 11.1904C17.4834 7.20014 14.2537 3.96539 10.2698 3.96539C6.2858 3.96539 3.05615 7.20014 3.05615 11.1904C3.05615 15.1806 6.2858 18.4154 10.2698 18.4154Z" fill="#DBE3EA" />
                                            <path d="M10.27 11.5404C9.92888 11.5404 9.646 11.2571 9.646 10.9154V6.74872C9.646 6.40705 9.92888 6.12372 10.27 6.12372C10.6111 6.12372 10.894 6.40705 10.894 6.74872V10.9154C10.894 11.2571 10.6111 11.5404 10.27 11.5404Z" fill="var(--blg-color-primary500)" />
                                            <path d="M12.6742 2.95705H7.86517C7.53236 2.95705 7.26611 2.69038 7.26611 2.35705C7.26611 2.02372 7.53236 1.74872 7.86517 1.74872H12.6742C13.0071 1.74872 13.2733 2.01538 13.2733 2.34872C13.2733 2.68205 13.0071 2.95705 12.6742 2.95705Z" fill="var(--blg-color-primary500)" />
                                        </svg>
                                        <div class="text-[#78818D] text-xs font-normal text-nowrap"><?php echo BLOGINA_ReadEstimateTime::blg_read_estimate_time(get_the_content()) . ' ' . __('Minutes Read', BLOGINAC_TEXT_DOMAIN); ?></div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

            <?php elseif ($post_count === 2 || $post_count === 3) : ?>
                <?php if($post_count === 2): ?>
                    <div class="lg:col-span-2 col-span-1 w-full h-full flex flex-col gap-6">
                <?php endif; ?>
                    <div class="blg-shadow-sm blog-post-card flex flex-col gap-y-5 rounded-3xl bg-white md:p-6 p-4 w-full">
                        <div class="flex md:gap-x-5 gap-x-2">
                            <a href="<?php the_permalink(); ?>" class="">

                                <?php if (has_post_thumbnail()) : ?>
                                    <img width="200px" height="100%" class="!rounded-[20px] md:min-w-[200px] min-w-[120px] md:min-h-[150px] min-h-[80px] object-cover" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title_attribute(); ?>">
                                <?php else : ?>
                                    <img width="200px" height="100%" class="!rounded-[20px] md:min-w-[200px] min-w-[140px] md:min-h-[150px] min-h-[100px] object-cover" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="Default Image">
                                <?php endif; ?>
                            </a>
                            <div class="flex flex-col gap-y-5 w-full">
                                <?php if ($this->show_tag) : ?>

                                    <?php
                                    $categories = get_the_category();

                                    if (!empty($categories)) {
                                        // Get the first category
                                        $first_category = $categories[0];
                                        $category_name = $first_category->name;
                                        $category_link = get_category_link($first_category->term_id);
                                    }
                                    ?>
                                    <a class="bg-[#78818D] text-white rounded text-xs font-normal text-nowrap max-w-max px-4 text-center py-[10px]" href="<?php echo esc_url($category_link); ?>">
                                        <?php echo esc_html($category_name); ?>
                                    </a>
                                <?php endif; ?>
                                <div class="flex flex-col md:gap-y-14 gap-y-4">
                                    <a href="<?php the_permalink(); ?>" class="w-full" aria-label="blog style2">
                                        <div class="flex gap-x-1 items-center">
                                            <svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
                                                <circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
                                            </svg>
                                            <?php
                                            $title = get_the_title();

                                            if (!empty($title)) {
                                                $title =  mb_strimwidth($title, 0, 55, '...'); // Limit to 50 characters, add "..." if truncated
                                            }
                                            ?>
                                            <h4 class="md:text-base text-[13px] font-bold text-[var(--blg-color-primary500)] "><?php echo $title; ?></h4>
                                        </div>
                                    </a>
                                    <?php if ($this->show_time) : ?>
                                        <div class="flex items-end gap-x-[2px] self-end">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                                                <path d="M10.2698 18.4154C14.2537 18.4154 17.4834 15.1806 17.4834 11.1904C17.4834 7.20014 14.2537 3.96539 10.2698 3.96539C6.2858 3.96539 3.05615 7.20014 3.05615 11.1904C3.05615 15.1806 6.2858 18.4154 10.2698 18.4154Z" fill="#DBE3EA" />
                                                <path d="M10.27 11.5404C9.92888 11.5404 9.646 11.2571 9.646 10.9154V6.74872C9.646 6.40705 9.92888 6.12372 10.27 6.12372C10.6111 6.12372 10.894 6.40705 10.894 6.74872V10.9154C10.894 11.2571 10.6111 11.5404 10.27 11.5404Z" fill="var(--blg-color-primary500)" />
                                                <path d="M12.6742 2.95705H7.86517C7.53236 2.95705 7.26611 2.69038 7.26611 2.35705C7.26611 2.02372 7.53236 1.74872 7.86517 1.74872H12.6742C13.0071 1.74872 13.2733 2.01538 13.2733 2.34872C13.2733 2.68205 13.0071 2.95705 12.6742 2.95705Z" fill="var(--blg-color-primary500)" />
                                            </svg>
                                            <div class="text-[#78818D] text-xs font-normal text-nowrap"><?php echo BLOGINA_ReadEstimateTime::blg_read_estimate_time(get_the_content()) . ' ' . __('Minutes Read', BLOGINAC_TEXT_DOMAIN); ?></div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php if ($post_count === 3) : ?>
                    </div>
                <?php endif; ?>
            <?php else : ?>
                <?php if ($post_count > 3 && $post_count === 4) : ?>
                    <div class="<?php echo $this->enable_slider ? $unique_id . 'swiper-container overflow-x-hidden p-2' : 'grid lg:grid-cols-3 md:grid-cols-2 grid-cols-1'; ?> col-span-5 gap-y-6 gap-x-6">
                    <?php echo $this->enable_slider ? '<div class="swiper-wrapper">': ''; ?>
                <?php endif; ?>

                        <div class="<?php echo $this->enable_slider ? 'swiper-slide': ''; ?> blg-shadow-sm blog-post-card hidden-mobile flex flex-col gap-y-5 rounded-3xl bg-white py-6 px-6 h-full">
                        <div class="flex flex-col gap-y-3">
                            <a href="<?php the_permalink(); ?>" class="w-full" aria-label="blog style2">
                                <div class="relative rounded-[var(--blg-radius-3xl)] overflow-hidden !lg:max-h-[190px] !lg:min-h-[190px] w-full h-[190px]">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <img width="100%" height="190" class="!lg:max-h-[190px] !lg:min-h-[190px] w-full !h-[190px] object-cover" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title_attribute(); ?>">
                                    <?php else : ?>
                                        <img width="100%" height="190" class="!lg:max-h-[190px] !lg:min-h-[190px] w-full !h-[190px] object-cover" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="Default Image">
                                    <?php endif; ?>
                                </div>

                            </a>

                            <?php if ($this->show_tag) :
                                $categories = get_the_category();
                                if (!empty($categories)) :
                                    $first_category = $categories[0];
                                    $category_name = $first_category->name;
                                    $category_link = get_category_link($first_category->term_id);
                                    ?>
                                    <a class="bg-[#78818D] text-white rounded text-xs font-normal text-nowrap max-w-max px-4 text-center py-[10px]" href="<?php echo esc_url($category_link); ?>">
                                        <?php echo esc_html($category_name); ?>
                                    </a>
                                <?php endif; endif; ?>

                            <div class="flex gap-x-1 items-center justify-between">
                                <a href="<?php the_permalink(); ?>" target="_blank" title="<?php the_title(); ?>">
                                    <div class="flex gap-x-1 items-center">
                                        <svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
                                            <circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
                                        </svg>
                                        <h4 class="md:text-base text-[13px] font-bold text-[var(--blg-color-primary500)]"><?php the_title(); ?></h4>
                                    </div>
                                </a>
                                <?php if ($this->show_time) : ?>
                                    <div class="flex items-center gap-x-[2px]">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
                                            <path d="M10.2698 18.4154C14.2537 18.4154 17.4834 15.1806 17.4834 11.1904C17.4834 7.20014 14.2537 3.96539 10.2698 3.96539C6.2858 3.96539 3.05615 7.20014 3.05615 11.1904C3.05615 15.1806 6.2858 18.4154 10.2698 18.4154Z" fill="#DBE3EA" />
                                            <path d="M10.27 11.5404C9.92888 11.5404 9.646 11.2571 9.646 10.9154V6.74872C9.646 6.40705 9.92888 6.12372 10.27 6.12372C10.6111 6.12372 10.894 6.40705 10.894 6.74872V10.9154C10.894 11.2571 10.6111 11.5404 10.27 11.5404Z" fill="var(--blg-color-primary500)" />
                                            <path d="M12.6742 2.95705H7.86517C7.53236 2.95705 7.26611 2.69038 7.26611 2.35705C7.26611 2.02372 7.53236 1.74872 7.86517 1.74872H12.6742C13.0071 1.74872 13.2733 2.01538 13.2733 2.34872C13.2733 2.68205 13.0071 2.95705 12.6742 2.95705Z" fill="var(--blg-color-primary500)" />
                                        </svg>
                                        <div class="text-[#78818D] text-xs font-normal text-nowrap"><?php echo BLOGINA_ReadEstimateTime::blg_read_estimate_time(get_the_content()) . ' ' . __('Minutes Read', BLOGINAC_TEXT_DOMAIN); ?></div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                <?php if ($post_count > 3 && $post_count === $this->posts_count) : ?>
                    <?php echo $this->enable_slider ? '</div>' : '';?>
                    <?php if($this->enable_slider && $this->show_pagination) : ?>
                        <div class="blog-<?php echo esc_attr($unique_id); ?>-pagination flex items-center justify-center pt-8 blg-swiper-pagination"></div>
                    <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

        <?php endwhile; ?>
    </div>

    <?php endif; ?>
    <?php wp_reset_postdata(); ?>
    <?php if ($this->show_buttons) : ?>
        <div class="flex justify-center mt-4 lg:hidden">
            <button aria-label="view all" onclick="showMoreItems(this, '.blg-widget-padding-y .hidden-mobile', 'hidden-mobile')" class="blg-btn-secondary">
                <?php echo $this->button_text; ?>
            </button>
        </div>
    <?php endif; ?>
</div>

<style>
    @media (max-width: 769px) {
        .hidden-mobile {
            display: none;
        }
    }
</style>

<?php if($this->enable_slider): ?>
    <script>
        new Swiper('.<?php echo esc_attr($unique_id); ?>swiper-container', {
            loop: <?php echo esc_attr($this->enable_loop); ?>,
            navigation: {
                nextEl: '.blog-<?php echo esc_attr($unique_id); ?>-button-next',
                prevEl: '.blog-<?php echo esc_attr($unique_id); ?>-button-prev',
            },
            pagination: {
                el: '.blog-<?php echo esc_attr($unique_id); ?>-pagination',
                clickable: true,
            },
            slidesPerView: 1,
            spaceBetween: 20,
            <?php if (!$this->enable_autoplay): ?>
            autoplay: false,
            <?php else: ?>
            autoplay: {
                delay: <?php echo esc_attr($this->autoplay_delay) ?? 0; ?>,
                disableOnInteraction: true,
                pauseOnMouseEnter: true,
            },
            <?php endif; ?>
            breakpoints: {
                768: { slidesPerView: <?php echo esc_attr($this->columns_tablet); ?> },
                1025: {slidesPerView: <?php  echo esc_attr($this->columns); ?> }
            },
        });
    </script>
<?php endif; ?>

