<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINAC_Elementor_SpeacialOffers $this */

$product_archive_url = get_post_type_archive_link('product');

$display_regular_price = BLOGINA_Settings::get('blg_show_regular_price');
$display_sale_price = BLOGINA_Settings::get('blg_show_sale_price');
$posts_query = $this->post_query;
$unique_id = uniqid($this->style_option .'-');
?>
<div class="overflow-hidden blg-course-<?php echo esc_attr($this->style_option); ?>">
    <?php if($this->show_title || $this->enable_slider): ?>
        <!-- Post Grid -->
        <div class="w-full lg:my-0 my-4">
            <div class="flex justify-between items-center course-post-title">
                <?php if($this->show_title): ?>
                    <div class="flex flex-col gap-y-2">
                        <h3 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php echo $this->main_title; ?></h3>
                        <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                            <div class="h-[3px] blg-title-underline rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if ($this->enable_slider) : ?>
                    <div class="flex gap-x-2 items-center">
                        <?php if($this->show_navigation): ?>
                            <div class="lg:flex hidden course-<?php echo esc_attr($unique_id); ?>-button-next">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="48" viewBox="0 0 49 48" fill="none">
                                    <path d="M31.5364 48H17.1364C5.13643 48 0.336426 43.2 0.336426 31.2V16.8C0.336426 4.8 5.13643 0 17.1364 0H31.5364C43.5364 0 48.3364 4.8 48.3364 16.8V31.2C48.3364 43.2 43.5364 48 31.5364 48Z" fill="var(--blg-color-primary500)" />
                                    <path d="M21.3123 32.472L29.7603 24L21.3123 15.528" stroke="var(--blg-color-primary400)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <div class="lg:flex hidden course-<?php echo esc_attr($unique_id); ?>-button-prev">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="48" viewBox="0 0 49 48" fill="none">
                                    <path d="M17.1364 48H31.5364C43.5364 48 48.3364 43.2 48.3364 31.2V16.8C48.3364 4.8 43.5364 0 31.5364 0H17.1364C5.13643 0 0.336426 4.8 0.336426 16.8V31.2C0.336426 43.2 5.13643 48 17.1364 48Z" fill="var(--blg-color-primary500)" />
                                    <path d="M27.3606 32.472L18.9126 24L27.3606 15.528" stroke="var(--blg-color-primary400)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>

    <div class=" <?php echo $this->enable_slider ? $unique_id . 'swiper-container' : 'grid xl:grid-cols-'. $this->columns .' lg:grid-cols-'. $this->columns_lg .' md:grid-cols-'. $this->columns_tablet .' grid-cols-1 gap-y-6 gap-x-6'; ?> mt-6">
        <?php echo $this->enable_slider ? '<div class="swiper-wrapper">': ''; ?>
        <?php while ($posts_query->have_posts()): $posts_query->the_post(); ?>
            <?php echo $this->enable_slider ? '<div class="swiper-slide">': ''; ?>
            <div class="blg-shadow-sm course-post-card blg_course_box_grid flex flex-col rounded-[20px] bg-white p-1 hover:border-t-2 hover:border-[var(--blg-color-secondary200)] transition-all duration-75">
                <div class="flex flex-col gap-y-3">

                    <?php $video_url = BLOGINA_Course::get_free_sessions_video(); ?>

                    <?php if (has_post_thumbnail()): ?>
                        <div class="bg-[var(--blg-color-primary400)] !rounded-tl-[20px] !rounded-tr-[20px] min-h-[150px] !max-h-[150px] is-image relative">
                            <a href="<?php the_permalink(); ?>" class="w-full relative" aria-label="course <?php echo esc_attr($this->style_option); ?>">
                                <img width="100%" height="212" class="!rounded-tl-[20px] !rounded-tr-[20px] w-full !h-[150px] !max-h-[150px] object-cover" src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title_attribute(); ?>">
                                <div class="blg-ratings absolute bottom-0 bg-white pr-2 rounded-tl-[5px] backdrop-blur-lg right-[-5px]">
                                    <?php echo BLOGINA_Course::get_rating(); ?>
                                </div>
                            </a>
                            <?php if ($video_url && $this->enable_video): ?>
                                <span onclick="video_modal('<?php echo esc_url($video_url); ?>', <?php echo esc_js($this->show_controls); ?> , <?php echo esc_js($this->video_autoplay); ?>);" class="course-play-<?php echo $this->style_option; ?>">
                                            <svg class="p-1 rounded-full lg:w-8 lg:h-8 w-6 h-6 transition duration-300 hover:fill-white" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="white">
                                                <path d="M6.16815 12.6368V15.3068C6.16815 18.6168 8.51815 19.9768 11.3881 18.3168L13.6981 16.9768L16.0081 15.6368C18.8781 13.9768 18.8781 11.2668 16.0081 9.60677L13.6981 8.26677L11.3881 6.92677C8.51815 5.29677 6.16815 6.64677 6.16815 9.96677V12.6368Z"></path>
                                            </svg>
                                        </span>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <div class="bg-[var(--blg-color-primary400)] !rounded-tl-[20px] !rounded-tr-[20px] min-h-[150px] !max-h-[150px] is-image relative">
                            <a href="<?php the_permalink(); ?>" class="w-full relative" aria-label="course <?php echo esc_attr($this->style_option); ?>">
                                <img width="100%" height="212" class="!rounded-tl-[20px] !rounded-tr-[20px] w-full !h-[150px] !max-h-[150px] object-cover" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="<?php the_title_attribute(); ?>">
                                <div class="blg-ratings absolute bottom-0 bg-white pr-2 rounded-tl-[5px] backdrop-blur-lg right-[-5px]">
                                    <?php echo BLOGINA_Course::get_rating(); ?>
                                </div>
                            </a>

                            <?php if ($video_url && $this->enable_video): ?>
                                <span onclick="video_modal('<?php echo esc_url($video_url); ?>', <?php echo esc_js($this->show_controls); ?> , <?php echo esc_js($this->video_autoplay); ?>);" class="bg-white/10 backdrop-blur-lg course-play-<?php echo $this->style_option; ?>">
                                            <svg class="p-1 rounded-full lg:w-8 lg:h-8 w-6 h-6 transition duration-300 hover:fill-white" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25" fill="white">
                                                <path d="M6.16815 12.6368V15.3068C6.16815 18.6168 8.51815 19.9768 11.3881 18.3168L13.6981 16.9768L16.0081 15.6368C18.8781 13.9768 18.8781 11.2668 16.0081 9.60677L13.6981 8.26677L11.3881 6.92677C8.51815 5.29677 6.16815 6.64677 6.16815 9.96677V12.6368Z"></path>
                                            </svg>
                                        </span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>


                    <div class="w-full flex flex-col">
                        <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>">
                            <div class="!flex !gap-x-1 !items-center <?php echo !$this->enable_countdown ? 'pb-2' : ''; ?>">
                                <svg class="!w-[6px] !h-[6px] !min-w-[6px] !min-h-[6px]" xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
                                    <circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
                                </svg>
                                <h4 class="text-[14px] font-semibold text-[var(--blg-color-primary500)]"><?php the_title(); ?></h4>
                            </div>
                        </a>
                    </div>


                </div>
                <div class="flex flex-col items-center">
                    <?php if($this->enable_countdown) : ?>
                        <?php
                        $sale_end_time = get_post_meta(get_the_ID(), '_sale_price_dates_to', true);
                        $sale_end_time = (int) $sale_end_time;
                        $sale_end_time = date('Y-m-d H:i:s', $sale_end_time);
                        ?>

                        <div data-end-time="<?php echo esc_attr($sale_end_time); ?>" id="countdown-<?php echo get_the_ID(); ?>"
                             class="countdown-timer countdown-wrapper text-center p-1 rounded bg-white/80 backdrop-blur-lg flex flex-row-reverse items-center justify-center gap-1 text-white ">

                            <div class="countdown-item flex flex-col items-center p-1 rounded-md">
                                <span class="countdown-number days text-xs font-medium text-[var(--blg-color-secondary200)]">00</span>
                                <span class="countdown-label text-[10px] text-gray-400">روز</span>
                            </div>

                            <div class="countdown-item flex flex-col items-center p-1 rounded-md">
                                <span class="countdown-number hours text-xs font-medium text-[var(--blg-color-secondary200)]">00</span>
                                <span class="countdown-label text-[10px] text-gray-400">ساعت</span>
                            </div>

                            <div class="countdown-item flex flex-col items-center p-1 rounded-md">
                                <span class="countdown-number minutes text-xs font-medium text-[var(--blg-color-secondary200)]">00</span>
                                <span class="countdown-label text-[10px] text-gray-400">دقیقه</span>
                            </div>

                            <div class="countdown-item flex flex-col items-center p-1 rounded-md">
                                <span class="countdown-number seconds text-xs font-medium text-[var(--blg-color-secondary200)]">00</span>
                                <span class="countdown-label text-[10px] text-gray-400">ثانیه</span>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php global $product; $price = BLOGINA_Course::get_price(true); ?>
                    <div class="flex gap-x-1 items-center self-baseline px-1 py-2">
                        <?php if ($display_sale_price && $price['sale_price']): ?>
                            <div class="text-[var(--blg-gray)] font-medium md:text-[15px] text-[13px]">
                                <del><?php echo BLOGINA_Course::short_price($price['regular_price']); ?></del>
                            </div>
                            <?php if ($price['sale_price'] && $price['regular_price'] && $display_regular_price): ?>
                                <div class="w-[1px] h-[15px] bg-[var(--blg-color-primary500)] opacity-50 mx-1"></div>
                            <?php endif; ?>
                            <div class="text-[var(--blg-color-secondary200)] font-medium md:text-[15px] text-[13px]"><?php echo BLOGINA_Course::short_price($price['sale_price']); ?></div>
                        <?php elseif ($display_regular_price): ?>
                            <div class="text-[var(--blg-color-secondary200)] font-medium md:text-[15px] text-[13px]"><?php echo BLOGINA_Course::short_price($price['regular_price']); ?></div>
                        <?php endif; ?>

                        <?php if ($display_regular_price || $display_sale_price): ?>
                            <?php if(!BLOGINA_Course::is_product_free($product)): ?>
                                <div class="text-[#858585] text-[14px] font-['YekanBakh']"><?php echo BLOGINA_Course::get_currency(); ?></div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>

                </div>
                <button aria-label="Add to Cart" type="submit" class="get_more flex gap-x-4 items-center add_to_cart_button ajax_add_to_cart" data-product_id="<?php echo get_the_ID(); ?>" data-quantity="1">
                    <div class="bg-[var(--blg-color-primary100)] absolute right-[10px] top-[9px] z-50 w-7 h-7 blg_add_to_cart_<?php echo $this->style_option; ?>">
                        <svg class="z-50 w-7 h-7" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path opacity="0.4" d="M16.0337 4.64997H15.7003L12.8837 1.8333C12.6587 1.6083 12.292 1.6083 12.0587 1.8333C11.8337 2.0583 11.8337 2.42497 12.0587 2.6583L14.0503 4.64997H5.95032L7.94199 2.6583C8.16699 2.4333 8.16699 2.06663 7.94199 1.8333C7.71699 1.6083 7.35032 1.6083 7.11699 1.8333L4.30866 4.64997H3.97533C3.22533 4.64997 1.66699 4.64997 1.66699 6.7833C1.66699 7.59163 1.83366 8.12497 2.18366 8.47497C2.38366 8.6833 2.62533 8.79163 2.88366 8.84997C3.12533 8.9083 3.38366 8.91663 3.63366 8.91663H16.367C16.6253 8.91663 16.867 8.89997 17.1003 8.84997C17.8003 8.6833 18.3337 8.1833 18.3337 6.7833C18.3337 4.64997 16.7753 4.64997 16.0337 4.64997Z" fill="var(--blg-color-secondary200)" />
                            <path d="M16.3755 8.91676H3.63379C3.38379 8.91676 3.12546 8.90843 2.88379 8.8501L3.93379 15.2501C4.16712 16.6834 4.79212 18.3334 7.56712 18.3334H12.2421C15.0505 18.3334 15.5505 16.9251 15.8505 15.3501L17.1088 8.8501C16.8755 8.9001 16.6255 8.91676 16.3755 8.91676ZM8.84212 14.3001C8.84212 14.6251 8.58379 14.8834 8.25879 14.8834C7.93379 14.8834 7.67546 14.6251 7.67546 14.3001V11.5501C7.67546 11.2251 7.93379 10.9668 8.25879 10.9668C8.58379 10.9668 8.84212 11.2251 8.84212 11.5501V14.3001ZM12.4088 14.3001C12.4088 14.6251 12.1505 14.8834 11.8255 14.8834C11.5005 14.8834 11.2421 14.6251 11.2421 14.3001V11.5501C11.2421 11.2251 11.5005 10.9668 11.8255 10.9668C12.1505 10.9668 12.4088 11.2251 12.4088 11.5501V14.3001Z" fill="var(--blg-color-secondary200)" />
                        </svg>
                    </div>
                </button>
            </div>
            <?php echo $this->enable_slider ? '</div>' : '';?>
        <?php endwhile; wp_reset_postdata();?>

        <?php echo $this->enable_slider ? '</div>' : '';?>
        <?php if($this->enable_slider && $this->show_pagination) : ?>
            <div class="course-<?php echo esc_attr($unique_id); ?>-pagination flex items-center justify-center pt-8 blg-swiper-pagination"></div>
        <?php endif; ?>
    </div>
</div>

<?php if($this->enable_slider): ?>
    <script>
        new Swiper('.<?php echo esc_attr($unique_id); ?>swiper-container', {
            loop: <?php echo esc_attr($this->enable_loop); ?>,
            navigation: {
                nextEl: '.course-<?php echo esc_attr($unique_id); ?>-button-next',
                prevEl: '.course-<?php echo esc_attr($unique_id); ?>-button-prev',
            },
            pagination: {
                el: '.course-<?php echo esc_attr($unique_id); ?>-pagination',
                clickable: true,
            },
            slidesPerView: 1,
            spaceBetween: 20,
            <?php if (!$this->enable_autoplay): ?>
            autoplay: false,
            <?php else: ?>
            autoplay: {
                delay: <?php echo esc_attr($this->autoplay_delay) ?? 0; ?>,
                disableOnInteraction: true,
                pauseOnMouseEnter: true,
            },
            <?php endif; ?>
            breakpoints: {
                768: { slidesPerView: <?php echo esc_attr($this->columns_tablet); ?> },
                1024: { slidesPerView: <?php echo esc_attr($this->columns_lg); ?> },
                1025: {slidesPerView: <?php echo esc_attr($this->columns); ?>}
            },
        });
    </script>
<?php endif; ?>

<?php if($this->enable_countdown): ?>
<script>
    jQuery(document).ready(function ($) {
        function initializeCountdownTimers() {
            $(".countdown-timer").each(function () {
                let $timer = $(this);
                let endTime = $timer.data("end-time");

                function updateCountdown() {
                    let now = new Date().getTime();
                    let targetTime = endTime ? new Date(endTime).getTime() : 0;
                    let remainingTime = endTime ? targetTime - now : 0;

                    let days, hours, minutes, seconds;

                    if (!endTime) {
                        // If no end time, show all zeros
                        days = hours = minutes = seconds = 0;
                    } else if (remainingTime <= 0) {
                        // If expired, show expired message
                        $timer.find(".days").text("00");
                        $timer.find(".hours").text("00");
                        $timer.find(".minutes").text("00");
                        $timer.find(".seconds").text("00");
                        return;
                    } else {
                        days = Math.floor(remainingTime / (1000 * 60 * 60 * 24));
                        hours = Math.floor((remainingTime % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        minutes = Math.floor((remainingTime % (1000 * 60 * 60)) / (1000 * 60));
                        seconds = Math.floor((remainingTime % (1000 * 60)) / 1000);
                    }

                    // Ensure all countdown elements exist before updating them
                    $timer.find(".days").text(String(days).padStart(2, "0"));
                    $timer.find(".hours").text(String(hours).padStart(2, "0"));
                    $timer.find(".minutes").text(String(minutes).padStart(2, "0"));
                    $timer.find(".seconds").text(String(seconds).padStart(2, "0"));
                }

                let countdownInterval = setInterval(updateCountdown, 1000);
                updateCountdown();
            });
        }

        initializeCountdownTimers();
    });
</script>

<?php endif; ?>
