<?php
// no direct access
defined('ABSPATH') || die();
/** @var BLOGINAC_PTypes_Course $this */

// Define the tabs dynamically with icons
$tabs = apply_filters('blg_course_admin_tabs', [
    'features'   => [
        'label' => esc_html__('Features', BLOGINAC_TEXT_DOMAIN),
        'icon' => 'fas fa-graduation-cap'
    ],
    'course'   => [
        'label' => esc_html__('Course View Type', BLOGINAC_TEXT_DOMAIN),
        'icon' => 'fas fa-chalkboard-teacher'
    ],
    'sessions'  => [
        'label' => esc_html__('Chapters & Sessions', BLOGINAC_TEXT_DOMAIN),
        'icon' => 'fas fa-book'
    ],
    'tutor' => [
        'label' => esc_html__('Course Tutor', BLOGINAC_TEXT_DOMAIN),
        'icon' => 'fas fa-user'
    ],
    'cqa' => [
        'label' => esc_html__('Common Questions', BLOGINAC_TEXT_DOMAIN),
        'icon' => 'fas fa-comment-dots'
    ],
]);


?>
<div class="blg-nav-tab-wrapper">
    <?php foreach ($tabs as $key => $tab): ?>
        <a href="#tab-<?php echo esc_attr($key); ?>" class="blg-nav-tab <?php echo $key === 'features' ? 'blg-nav-tab-active' : ''; ?>" data-tab="<?php echo esc_attr($key); ?>">
            <i class="<?php echo esc_attr($tab['icon']); ?>"></i>  <!-- Font Awesome icon -->
            <?php echo esc_html($tab['label']); ?>
        </a>
    <?php endforeach; ?>
</div>

