<?php
// no direct access
defined('ABSPATH') || die();

/** @var WP_Post $post */
global $post;

// Retrieve 'blg' meta key
$blg = get_post_meta($post->ID, 'blg-course', true);
$blg = is_array($blg) ? $blg : []; // Ensure $blg is an array

// Extract individual fields
$questions = isset($blg['common_questions']) ? $blg['common_questions'] : [];


?>
<div class="blg-metabox blg-course-module-price">
    <div class="blg-qa">
        <div class="blg-qa-button">
            <label for="blg_questions" class="blg-price-label blg-col-12"><?php esc_html_e('Questions and Answers', BLOGINAC_TEXT_DOMAIN); ?></label>
            <button type="button" id="blg_add_qa" class="blg-button mt-4"><?php esc_html_e('Add Question/Answer', BLOGINAC_TEXT_DOMAIN); ?></button>
        </div>
        <div class="blg-qa-box" id="blg_questions_container" class="flex flex-col gap-y-2 mt-6">
            <?php
            foreach ($questions as $index => $qa) {
            ?>
                <div class="blg-qa-pair">
                    <div class="blg-qa-title">
                        <input type="text" name="blg[common_questions][<?php echo esc_attr($index); ?>][question]" placeholder="<?php esc_attr_e('Question', BLOGINAC_TEXT_DOMAIN); ?>" value="<?php echo esc_attr($qa['question']); ?>" class="w-full p-2 border border-[var(--blg-color-primary400)] rounded" />
                        <button type="button" class="blg-remove-qa blg-button"><i class="fa fa-trash" aria-hidden="true"></i></button> <!-- Trash icon -->
                    </div>

                    <textarea name="blg[common_questions][<?php echo esc_attr($index); ?>][answer]" placeholder="<?php esc_attr_e('Answer', BLOGINAC_TEXT_DOMAIN); ?>" class="w-full p-2 border border-[var(--blg-color-primary400)] rounded"><?php echo esc_textarea($qa['answer']); ?></textarea>
                </div>
            <?php
            }
            ?>
        </div>
    </div>
</div>


<script>
    jQuery(document).ready(function($) {
        // Initialize question index based on the existing count of questions
        let questionIndex = <?php echo count($questions); ?>; // Start from the existing count

        // Add new question-answer pair when the 'Add Question/Answer' button is clicked
        $('#blg_add_qa').on('click', function() {
            // Append new question-answer pair to the container
            $('#blg_questions_container').append(`
                <div class="blg-qa-pair">
                    <div class="blg-qa-title">
                        <input type="text" name="blg[common_questions][${questionIndex}][question]" placeholder="<?php esc_attr_e('Question', BLOGINAC_TEXT_DOMAIN); ?>" class="w-full p-2 border border-[var(--blg-color-primary400)] rounded" />
                        <button type="button" class="blg-remove-qa blg-button"><i class="fa fa-trash" aria-hidden="true"></i></button> <!-- Trash icon -->
                    </div>
                    <textarea name="blg[common_questions][${questionIndex}][answer]" placeholder="<?php esc_attr_e('Answer', BLOGINAC_TEXT_DOMAIN); ?>" class="w-full p-2 border border-[var(--blg-color-primary400)] rounded"></textarea>
                </div>
            `);

            // Increment the question index for the next item
            questionIndex++;
        });

        // Remove a question-answer pair when the 'Remove' button is clicked
        $(document).on('click', '.blg-remove-qa', function() {
            // Remove the closest parent .blg-qa-pair div
            $(this).closest('.blg-qa-pair').remove();
        });
    });
</script>