<?php
$price_range = BLOGINA_Course::get_min_max_product_price();
$min_price = $price_range['min'];
$max_price = $price_range['max'];
?>


<div id="price-range" class="course-sidebar-widget-section hidden">
    <div id="slider"></div>
    <div class="flex flex-row-reverse items-center justify-between mt-2">
        <span class="text-xs text-[var(--blg-color-primary500)]" id="min-price-display"><?php echo esc_html($min_price); ?></span>
        <span class="text-xs text-[var(--blg-color-primary500)]" id="max-price-display"><?php echo esc_html($max_price); ?></span>
    </div>
</div>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        const slider = document.getElementById('slider');
        const minPriceDisplay = document.getElementById('min-price-display');
        const maxPriceDisplay = document.getElementById('max-price-display');

        // Initialize the slider
        noUiSlider.create(slider, {
            start: [<?php echo esc_attr($min_price); ?>, <?php echo esc_attr($max_price); ?>],
            connect: true,
            range: {
                'min': <?php echo esc_attr($min_price); ?>,
                'max': <?php echo esc_attr($max_price); ?>
            },
            step: 10000
        });

        // Display the values
        slider.noUiSlider.on('update', function(values, handle) {
            if (handle === 0) {
                minPriceDisplay.innerText = Math.round(values[0]).toLocaleString();
            } else {
                maxPriceDisplay.innerText = Math.round(values[1]).toLocaleString();
            }
        });
        
    });
</script>