<?php

$assets = new BLOGINAC_Assets();
$assets->footer('<script>
jQuery(document).ready(function() {
    jQuery("#course-filter-form").bloginaCourseSidebarFilter({
        ajax_url: "' . admin_url('admin-ajax.php') . '",
        nonce: "' . wp_create_nonce('lsd_filter_course_nonce') . '"
    });
});
</script>');

// Get terms for category and type filters
$categories = get_terms([
    'taxonomy' => BLOGINAC_Base::TAX_COURSE_CATEGORY,
    'hide_empty' => true,
]);

$types = get_terms([
    'taxonomy' => BLOGINAC_Base::TAX_COURSE_TYPE,
    'hide_empty' => true,
]);
?>
<div class="course-sidebar-widget bg-white blg-shadow-sm p-5 rounded-[20px] transition-all">
    <div class="course-sidebar-widget-filters">
        <form id="course-filter-form" class="flex flex-col gap-y-4">
            <?php echo BLOGINAC_Form::nonce('lsd_filter_course_nonce', 'nonce'); ?>

            <?php
            if (!empty($category_title)) {
                echo $this->render_widget_title($category_title, '', '');
            }
            $this->render_filter('', 'categories-list', 'category-filter', $categories);

            if (!empty($type_title)) {
                echo $this->render_widget_title($type_title, '', '');
            }
            $this->render_filter('', 'types-list', 'type-filter', $types);

            if (!empty($price_title)) {
                echo $this->render_widget_title($price_title, '', '');
            }
            $this->render_price_filter();
            ?>
        </form>
    </div>