<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Blog_Settings extends BLOGINAC_Elementor_Posts
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {

        // Get all categories
        $categories = get_categories();
        $categories_options = [
            '' => __('All Categories', BLOGINAC_TEXT_DOMAIN)
        ];
        foreach ($categories as $category) {
            $categories_options[$category->term_id] = $category->name;
        }

        // Define ordering options
        $order_options = [
            'date' => __('Date', BLOGINAC_TEXT_DOMAIN),
            'title' => __('Title', BLOGINAC_TEXT_DOMAIN),
            'rand' => __('Random', BLOGINAC_TEXT_DOMAIN),
        ];
        // Posts Section
        $this->start_controls_section(
            'posts_section',
            [
                'label' => __('Settings', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Style Control
        $this->add_control(
            'style_option',
            [
                'label' => __('Style Option', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style1' => __('Style 1', BLOGINAC_TEXT_DOMAIN),
                    'style2' => __('Style 2', BLOGINAC_TEXT_DOMAIN),
                ],
                'default' => 'style1',
            ]
        );

        // Number of Posts Control
        $this->add_control(
            'posts_count',
            [
                'label' => __('Number of Posts', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => $this->style_option === 'style1' ? 8 : ($this->enable_slider ? 10 : 6),
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ]
        );

        $this->add_control(
            'post_category',
            [
                'label' => __('Post Category', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $categories_options,
                'default' => '',
            ]
        );

        $this->add_control(
            'post_order',
            [
                'label' => __('Post Order By', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $order_options,
                'default' => 'rand',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'title_section',
            [
                'label' => __('Title and Buttons', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'main_title',
            [
                'label' => __('Main Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Blog', BLOGINAC_TEXT_DOMAIN),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'show_buttons',
            [
                'label' => __('Show Buttons', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        
        $this->add_control(
            'button_text',
            [
                'label' => __('Button Text', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('view all', BLOGINAC_TEXT_DOMAIN),
                'condition' => [
                    'show_buttons' => 'yes',
                ],
            ]
        );
        
        // End Section
        $this->end_controls_section();

        $this->start_controls_section(
            'slider_section',
            [
                'label' => __('Slider', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'enable_sliders',
            [
                'label' => __('Enable slider', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'enable_autoplay',
            [
                'label' => __('Autoplay', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'autoplay_delay',
            [
                'label' => __('AutoPlay Delay (ms)', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1000,
                'max' => 10000,
                'step' => 100,
                'default' => 2000,
                'condition' => [
                    'enable_autoplay' => 'yes',
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'enable_loop',
            [
                'label' => __('Loop', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => __('Show Pagination', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_navigation',
            [
                'label' => __('Show Navigations', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'columns_section',
            [
                'label' => __('Columns', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'columns_desktop',
            [
                'label' => __('Desktop Columns', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => $this->style_option === 'style1' ? 4 : 3,
                'min' => 1,
                'max' => 4,
                'step' => 1,
            ]
        );

        $this->add_control(
            'columns_lg',
            [
                'label' => __('LG Columns', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3,
                'min' => 1,
                'max' => 4,
                'step' => 1,
                'description' => __('Select the number of columns for large screen (1024px above)', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'columns_tablet',
            [
                'label' => __('Tablet Columns', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 2,
                'min' => 1,
                'max' => 3,
                'step' => 1,
                'description' => __('Select the number of columns for tablet (768px to 1024px) ', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
