<?php
// Prevent direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Controls_Title')):

/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Category_Title extends BLOGINAC_Elementor_Category {

    /**
     * Add title style controls
     */
    public function register_controls() {
        // Start Title Style Section
        $this->start_controls_section(
            'section_title_styles',
            [
                'label' => __('Title Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Title Typography Control
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'category_typography',
                'label' => __('Title Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} span.category-name',
            ]
        );

        // Title Color Control
        $this->add_control(
            'category_text_color',
            [
                'label' => __('Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'var(--blg-color-primary500)',
                'selectors' => [
                    '{{WRAPPER}} .blg-category-bg' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'category_bg_color',
            [
                'label' => __('Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .blg-category-bg' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'category_hover_text_color',
            [
                'label' => __('Hover Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .blg-category-bg:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'category_hover_bg_color',
            [
                'label' => __('Background Hover Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'var(--blg-color-secondary200)',
                'selectors' => [
                    '{{WRAPPER}} .blg-category-bg:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // Card Border Radius Control
        $this->add_control(
            'category_card_radius',
            [
                'label' => __('Border Radius', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 24,
                    'right' => 24,
                    'bottom' => 24,
                    'left' => 24,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .blg-category-bg' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'catgeory_card_shadow',
            [
                'label' => __('Shadow', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::BOX_SHADOW,
                'default' => [
                    'horizontal' => '0',
                    'vertical' => '0',
                    'blur' => '32',
                    'spread' => '0',
                    'color' => 'rgba(58, 70, 84, 0.1)',
                ],
                'selectors' => [
                    '{{WRAPPER}} .blg-category-bg' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
                ],
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}

endif;
