<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Comments_Items extends BLOGINAC_Elementor_Comments
{
    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Adding a new style section for Title and Card styling
        $this->start_controls_section(
            'section_comment_card_styles',
            [
                'label' => __('comments Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE, // Add this section to the Style tab
            ]
        );

        // Card Background Color Control
        $this->add_control(
            'commnets_section_bg_color',
            [
                'label' => __('Section Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'var(--blg-color-primary500)',
                'selectors' => [
                    '{{WRAPPER}} .blg-comments-section' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_bg_color',
            [
                'label' => __('Item Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-comments-items' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'card_title_typography',
                'label' => __('Author Title Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blg-comment-author',
            ]
        );

        $this->add_control(
            'card_title_color',
            [
                'label' => __('Author Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-comment-author' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'card_desc_typography',
                'label' => __('Description Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blg-comment-desc',
            ]
        );

        $this->add_control(
            'card_desc_color',
            [
                'label' => __('Description Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-comment-desc' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_icon_color',
            [
                'label' => __('Icon Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-comment-icon path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        // Card Border Radius Control
        $this->add_control(
            'card_radius',
            [
                'label' => __('Item Border Radius', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 24,
                    'right' => 24,
                    'bottom' => 24,
                    'left' => 24,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .blg-comments-items' => 'border-radius: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
