<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Coursecta_Settings extends BLOGINAC_Elementor_CourseCTA
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Start Section
        $this->start_controls_section(
            'bloginac_content_section',
            [
                'label' => __('Content', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Section Title Control
        $this->add_control(
            'section_title',
            [
                'label' => __('Section Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('We are with you with training', BLOGINAC_TEXT_DOMAIN),
                'placeholder' => __('Enter your title', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // Repeater for CTA Items
        $repeater = new \Elementor\Repeater();

        // Icon Control
        $repeater->add_control(
            'icon',
            [
                'label' => __('Icon', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-star',
                    'library' => 'fa-solid',
                ],
                'label_block' => true,
            ]
        );

        // Title Control
        $repeater->add_control(
            'title',
            [
                'label' => __('Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Example Text', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // URL Control
        $repeater->add_control(
            'url',
            [
                'label' => __('URL', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', BLOGINAC_TEXT_DOMAIN),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        // Add Repeater Control to Main Control
        $this->add_control(
            'cta_items',
            [
                'label' => __('CTA Items', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => __('هدف گذاری', BLOGINAC_TEXT_DOMAIN),
                        'url' => ['url' => '#'],
                    ],
                    [
                        'title' => __('بازاریابی', BLOGINAC_TEXT_DOMAIN),
                        'url' => ['url' => '#'],
                    ],
                    [
                        'title' => __('تبلیغات', BLOGINAC_TEXT_DOMAIN),
                        'url' => ['url' => '#'],
                    ],
                    [
                        'title' => __('قیمت گذاری', BLOGINAC_TEXT_DOMAIN),
                        'url' => ['url' => '#'],
                    ],
                    [
                        'title' => __('ترویج', BLOGINAC_TEXT_DOMAIN),
                        'url' => ['url' => '#'],
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
