<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Hashtags_Items extends BLOGINAC_Elementor_Hashtags
{
    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Adding a new style section for Title and Card styling
        $this->start_controls_section(
            'section_hashtag_card_styles',
            [
                'label' => __('Hashtags Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE, // Add this section to the Style tab
            ]
        );

        // Card Background Color Control
        $this->add_control(
            'section_bg_color',
            [
                'label' => __('Section Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'var(--blg-color-primary500)',
                'selectors' => [
                    '{{WRAPPER}} .hashtag-section' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_bg_color',
            [
                'label' => __('Item Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .hashtag-post-card a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'card_title_color',
            [
                'label' => __('Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .hashtag-post-card a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'hashtag_hover_text_color',
            [
                'label' => __('Hover Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .hashtag-post-card a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'hashtag_hover_bg_color',
            [
                'label' => __('Background Hover Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'var(--blg-color-secondary200)',
                'selectors' => [
                    '{{WRAPPER}} .hashtag-post-card a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        
        // Card Padding Control
        $this->add_control(
            'card_padding',
            [
                'label' => __('Item Padding', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'default' => [
                    'top' => 12,
                    'right' => 16,
                    'bottom' => 12,
                    'left' => 16,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .hashtag-post-card a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Card Border Radius Control
        $this->add_control(
            'card_radius',
            [
                'label' => __('Item Border Radius', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 24,
                    'right' => 24,
                    'bottom' => 24,
                    'left' => 24,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .hashtag-post-card a' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
