<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Hashtags_Settings extends BLOGINAC_Elementor_Hashtags
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Start Section
        $this->start_controls_section(
            'bloginac_content_section',
            [
                'label' => __('Content', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Title Control
        $this->add_control(
            'section_title',
            [
                'label' => __('Section Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Top Hashtags', BLOGINAC_TEXT_DOMAIN),
                'placeholder' => __('Enter your title', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'title',
            [
                'label' => __('Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Hashtag', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $repeater->add_control(
            'url',
            [
                'label' => __('URL', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', BLOGINAC_TEXT_DOMAIN),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'slides',
            [
                'label' => __('Hashtags', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => __('Hashtag 1', BLOGINAC_TEXT_DOMAIN),
                        'url' => ['url' => '#'],
                    ],
                    [
                        'title' => __('Hashtag 2', BLOGINAC_TEXT_DOMAIN),
                        'url' => ['url' => '#'],
                    ],
                    [
                        'title' => __('Hashtag 3', BLOGINAC_TEXT_DOMAIN),
                        'url' => ['url' => '#'],
                    ],
                    [
                        'title' => __('Hashtag 4', BLOGINAC_TEXT_DOMAIN),
                        'url' => ['url' => '#'],
                    ],
                ],
                'separator' => 'after',
                'title_field' => '{{{ title }}}',
            ]
        );

        // End Section
        $this->end_controls_section();
    }

}
