<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Title_Settings extends BLOGINAC_Elementor_Title
{
    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Title Section
        $this->start_controls_section(
            'title_section',
            [
                'label' => __('Blogina Title Settings', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'style_option',
            [
                'label' => __('Style Option', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style1' => __('Style 1', BLOGINAC_TEXT_DOMAIN),
                    'style2' => __('Style 2', BLOGINAC_TEXT_DOMAIN),
                ],
                'default' => 'style1',
                'description' => __('Choose the style for the title section.', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'main_title',
            [
                'label' => __('Main Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('The Title Goes Here', BLOGINAC_TEXT_DOMAIN),
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                    'tags' => [
                        \Elementor\Core\DynamicTags\Tag::get_type( 'post_title' ),
                        \Elementor\Core\DynamicTags\Tag::get_type( 'site_title' ),
                        \Elementor\Core\DynamicTags\Tag::get_type( 'product_title' ),
                    ],
                ],
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __('Description', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('This is sample description', BLOGINAC_TEXT_DOMAIN),
                'label_block' => true,
                'condition' => [
                    'style_option' => 'style2',
                ],
            ]
        );

        $this->add_control(
            'show_buttons',
            [
                'label' => __('Show Buttons', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __('Button Text', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('view all', BLOGINAC_TEXT_DOMAIN),
                'condition' => [
                    'show_buttons' => 'yes',
                ],
            ]
        );

        $shop_page_id = wc_get_page_id('shop'); 
        $this->add_control(
            'button_page',
            [
                'label' => __('Button Link (Select Page)', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_all_pages(),
                'default' => $shop_page_id,
                'condition' => [
                    'show_buttons' => 'yes',
                ],
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
