<?php
// Prevent direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Controls_Title')):

/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Title_Title extends BLOGINAC_Elementor_Title
{
    /**
     * Add title style controls
     */
    public function register_controls() {
        // Start Title Style Section
        $this->start_controls_section(
            'section_title_styles',
            [
                'label' => __('Title Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Title Typography Control
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Title Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blg-title h3',
            ]
        );

        // Title Color Control
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-title h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'label' => __('Description Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blg-description',
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __('Description Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_underline_color',
            [
                'label' => __('Title Underline Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-title .blg-title-underline' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => __('Button Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blg-title .blg-btn-secondary',
            ]
        );

        // Button Text Color Control
        $this->add_control(
            'show_more_button_color',
            [
                'label' => __('Button Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-title .blg-btn-secondary' => 'color: {{VALUE}};',
                ],
            ]
        );

        // Button Background Color Control
        $this->add_control(
            'show_more_button_bg',
            [
                'label' => __('Button Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-title .blg-btn-secondary' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // Button Text Color Control
        $this->add_control(
            'show_more_button_icon_color',
            [
                'label' => __('Button Icon Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-title .blg-btn-icon path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        // Button Background Color Control
        $this->add_control(
            'show_more_button_icon_bg',
            [
                'label' => __('Button Icon Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blg-title .blg-btn-icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'button_alignment',
            [
                'label' => __('Button Alignment', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'baseline' => [
                        'title' => __('Right', BLOGINAC_TEXT_DOMAIN),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => __('Center', BLOGINAC_TEXT_DOMAIN),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => __('Left', BLOGINAC_TEXT_DOMAIN),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'default' => 'baseline',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .blg-title .blg-btn-secondary' => 'align-self: {{VALUE}};',
                ],
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}

endif;
