<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_UpdatedBlog_LatestPosts extends BLOGINAC_Elementor_UpdatedBlogs
{
    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Adding a new style section for Title and Card styling
        $this->start_controls_section(
            'section_lates_post_card_styles',
            [
                'label' => __('Latest Post Card Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE, // Add this section to the Style tab
            ]
        );

        // Card Background Color Control
        $this->add_control(
            'latest_post_bg_color',
            [
                'label' => __('Card Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-latest-post-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'latest_title_color',
            [
                'label' => __('Latest Post Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-latest-post-card h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'latest_date_text_color',
            [
                'label' => __('Latest Post Date Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .latest-post-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'latest_title_underline_color',
            [
                'label' => __('Title Underline Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-latest-post-card .blg-title-underline' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'latest_post_title_color',
            [
                'label' => __('Post Title Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-latest-post-card h4' => 'color: {{VALUE}};',
                ],
            ]
        );
        

        $this->add_control(
            'latest_post_title_icon_color',
            [
                'label' => __('Post Title Icon Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-latest-post-card svg circle' => 'fill: {{VALUE}};',
                ],
            ]
        );

        // Card Padding Control
        $this->add_control(
            'latest_post_padding',
            [
                'label' => __('Box Padding', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'default' => [
                    'top' => 24,
                    'right' => 24,
                    'bottom' => 24,
                    'left' => 24,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-latest-post-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Card Border Radius Control
        $this->add_control(
            'latest_post_radius',
            [
                'label' => __('Box Border Radius', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 24,
                    'right' => 24,
                    'bottom' => 24,
                    'left' => 24,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .updatedblog-latest-post-card' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'latest_post_shadow',
                'label' => __('Card Shadow', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .updatedblog-latest-post-card',
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
