<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Contact')):

    /**
     * Elementor Contact Widget.
     *
     * @class BLOGINAC_Elementor_Contact
     * @version 1.0.0
     */
    class BLOGINAC_Elementor_Contact extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-contact';
        }

        public function get_title()
        {
            return __('Contact Form', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fas fa-mail-bulk';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Contact Form Section
            $this->start_controls_section(
                'contact_section',
                [
                    'label' => __('Contact Form Settings', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            $this->add_control(
                'email',
                [
                    'label' => __('Recipient Email', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => get_option('admin_email'),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'success_message',
                [
                    'label' => __('Success Message', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('Thank you for your message. We will get back to you soon!', BLOGINAC_TEXT_DOMAIN),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'error_message',
                [
                    'label' => __('Error Message', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('Something went wrong. Please try again later.', BLOGINAC_TEXT_DOMAIN),
                    'label_block' => true,
                ]
            );

            $this->add_control(
                'show_subject',
                [
                    'label' => __('Show Subject Field', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                    'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            // End Section
            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();

            $recipient_email = !empty($settings['email']) ? sanitize_email($settings['email']) : get_option('admin_email');
            $success_message = !empty($settings['success_message']) ? esc_html($settings['success_message']) : __('Thank you for your message. We will get back to you soon!', BLOGINAC_TEXT_DOMAIN);
            $error_message = !empty($settings['error_message']) ? esc_html($settings['error_message']) : __('Something went wrong. Please try again later.', BLOGINAC_TEXT_DOMAIN);
            $show_subject = $settings['show_subject'] === 'yes';

?>
            <div class="contact-widget p-6 rounded-[var(--blg-radius-lg)]">
                <form id="contact-form" method="post" action="<?php echo esc_url(admin_url('admin-ajax.php')); ?>" class="space-y-4">
                    <input type="hidden" name="action" value="process_contact_form">
                    <input type="hidden" name="recipient_email" value="<?php echo esc_attr($recipient_email); ?>">

                    <div class="form-group">
                        <?php echo BLOGINAC_Form::text([
                            'id' => 'blg_contact_form_subject_elementor_widget',
                            'name' => 'subject',
                            'placeholder' => esc_html__('Name and surname...', BLOGINAC_TEXT_DOMAIN),
                            'class' => 'mt-1 block font-[YekanBakh] !text-[var(--blg-color-primary200)] text-[14px] font-normal tracking-[-0.28px]',
                            'required' => true,
                        ]); ?>
                    </div>


                    <div class="form-group">
                        <?php echo BLOGINAC_Form::tel([
                            'id' => 'blg_contact_form_email_elementor_widget',
                            'name' => 'email',
                            'placeholder' => esc_html__('phone number', BLOGINAC_TEXT_DOMAIN),
                            'class' => 'mt-1 block text-right font-[YekanBakh] !text-[var(--blg-color-primary200)] text-[14px] font-normal tracking-[-0.28px]',
                            'required' => true,
                        ]); ?>
                    </div>
                    <?php if ($show_subject) : ?>
                        <div class="form-group">
                            <?php echo BLOGINAC_Form::select([
                                'id' => 'blg_contact_form_subject_elementor_widget',
                                'name' => 'name',
                                'placeholder' => esc_html__('Request subject', BLOGINAC_TEXT_DOMAIN),
                                'class' => 'mt-1 block font-[YekanBakh] !text-[var(--blg-color-primary200)] text-[14px] font-normal tracking-[-0.28px]',
                                'required' => true,
                                'options' => [
                                    '0' => 'موضوع درخواست',
                                    '1' => 'موضوع اول',
                                ],
                            ]); ?>
                        </div>
                    <?php endif; ?>


                    <div class="form-group">
                        <?php echo BLOGINAC_Form::textarea([
                            'id' => 'blg_contact_form_message_elementor_widget',
                            'name' => 'message',
                            'placeholder' => esc_html__('request description', BLOGINAC_TEXT_DOMAIN),
                            'class' => 'mt-1 block resize-none font-[YekanBakh] !text-[var(--blg-color-primary200)] !text-[14px] tracking-[-0.28px]',
                            'required' => true,
                            'rows' => 6,
                        ]); ?>
                    </div>
                    
                    <?php
                        echo BLOGINAC_Form::submit([
                            'label'=> esc_html__('Send Message', BLOGINAC_TEXT_DOMAIN),
                            'id' => 'blg_contact_form_submit',
                            'class' => 'w-full py-4 px-8 blg-btn-secondary',
                        ])
                    ?>
                    <div id="form-response" class="form-response mt-4"></div>
                </form>
                <?php BLOGINAC_Assets::footer("<script> jQuery(document).ready(function($) { $('#contact-form').on('submit', function(e) { e.preventDefault(); var form = $(this); var formData = new FormData(this); $.ajax({ url: form.attr('action'), type: 'POST', data: formData, contentType: false, processData: false, success: function(data) { var responseDiv = $('#form-response'); responseDiv.removeClass('text-green-500 text-red-500'); if (data.success) { responseDiv.text('<?php echo esc_js($success_message); ?>') .addClass('text-green-500'); } else { responseDiv.text('<?php echo esc_js($error_message); ?>') .addClass('text-red-500'); } } }); }); }); </script>"); ?>
            </div>
<?php
        }
    }

endif;
