<?php
// no direct access
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

defined('ABSPATH') || die();

/**
 * Elementor Content Widget.
 *
 * @class BLOGINAC_Elementor_Content
 * @version 1.0.0
 */
class BLOGINAC_Elementor_Content extends BLOGINAC_Elementor_Single
{
    public function get_name()
    {
        return 'bloginac-content';
    }

    public function get_title()
    {
        return __('Blogina Content', BLOGINAC_TEXT_DOMAIN);
    }

    public function get_icon()
    {
        return 'fas fa-paragraph';
    }

    protected function register_controls()
    {
        // Content section
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Settings', BLOGINAC_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        // Content color control
        $this->add_control(
            'content_color',
            [
                'label' => __('Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blgelm-single-content' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'label' => __('Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blgelm-single-content',
            ]
        );

        // Text alignment control
        $this->add_control(
            'content_alignment',
            [
                'label' => __('Text Alignment', BLOGINAC_TEXT_DOMAIN),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', BLOGINAC_TEXT_DOMAIN),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', BLOGINAC_TEXT_DOMAIN),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', BLOGINAC_TEXT_DOMAIN),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => __('Justify', BLOGINAC_TEXT_DOMAIN),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .blgelm-single-content' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function course(BLOGINAC_Entity_Course $course): string
    {
        $content = $course->get_content($course->id());

        return '<div class="blgelm-single-content blg-single-entry-content">' . $content . '</div>';
    }
}
