<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Countdown')):

    /**
     * Elementor Countdown Timer Widget.
     *
     * @class BLOGINAC_Elementor_Countdown_Timer
     * @version 2.0.0
     */
    class BLOGINAC_Elementor_Countdown extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-countdown-timer';
        }

        public function get_title()
        {
            return __('Countdown Timer', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fas fa-stopwatch';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Section
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('Countdown Timer Settings', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            // Countdown End Date
            $this->add_control(
                'end_date',
                [
                    'label' => __('End Date & Time', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::DATE_TIME,
                    'default' => date('Y-m-d H:i:s', strtotime('+7 days')),
                ]
            );

            // Show Labels
            $this->add_control(
                'show_labels',
                [
                    'label' => __('Show Labels (Days, Hours, etc.)', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                    'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                    'default' => 'yes',
                ]
            );

// Layout Control
            $this->add_control(
                'layout',
                [
                    'label' => __('Layout', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        'row' => __('Horizontal (Row)', BLOGINAC_TEXT_DOMAIN),
                        'row-reverse' => __('Horizontal Reverse (Row-Reverse)', BLOGINAC_TEXT_DOMAIN),
                        'column' => __('Vertical (Column)', BLOGINAC_TEXT_DOMAIN),
                        'column-reverse' => __('Vertical Reverse (Column-Reverse)', BLOGINAC_TEXT_DOMAIN),
                    ],
                    'default' => 'row',
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-countdown-timer' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );


            $this->end_controls_section();

            // Style Section
            $this->start_controls_section(
                'style_section',
                [
                    'label' => __('Style', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            // Box Background Color
            $this->add_control(
                'box_bg_color',
                [
                    'label' => __('Box Background Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#f0f0f0',
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-countdown-box' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            // Box Text Color
            $this->add_control(
                'text_color',
                [
                    'label' => __('Text Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#333333',
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-countdown-box span' => 'color: {{VALUE}};',
                    ],
                ]
            );

            // Box Border Radius
            $this->add_control(
                'box_border_radius',
                [
                    'label' => __('Border Radius', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => ['px', '%'],
                    'range' => [
                        'px' => ['min' => 0, 'max' => 50],
                    ],
                    'default' => [
                        'size' => 10,
                        'unit' => 'px',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-countdown-box' => 'border-radius: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            // Typography
            $this->add_group_control(
                \Elementor\Group_Control_Typography::get_type(),
                [
                    'name' => 'typography',
                    'label' => __('Typography', BLOGINAC_TEXT_DOMAIN),
                    'selector' => '{{WRAPPER}} .bloginac-countdown-box span',
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $end_date = strtotime($settings['end_date']);
            $show_labels = $settings['show_labels'] === 'yes';

            $uniq_id = uniqid('bloginac-countdown-');

            ?>
            <div id="<?php echo esc_attr($uniq_id); ?>" class="bloginac-countdown-timer">
                <div class="bloginac-countdown-box">
                    <span class="days">00</span>
                    <?php echo $show_labels ? '<span class="label">'. esc_html__('Days', BLOGINAC_TEXT_DOMAIN) .'</span>' : ''; ?>
                </div>
                <div class="bloginac-countdown-box">
                    <span class="hours">00</span>
                    <?php echo $show_labels ? '<span class="label">'. esc_html__('Hours', BLOGINAC_TEXT_DOMAIN) .'</span>' : ''; ?>
                </div>
                <div class="bloginac-countdown-box">
                    <span class="minutes">00</span>
                    <?php echo $show_labels ? '<span class="label">'. esc_html__('Mniutes', BLOGINAC_TEXT_DOMAIN) .'</span>' : ''; ?>
                </div>
                <div class="bloginac-countdown-box">
                    <span class="seconds">00</span>
                    <?php echo $show_labels ? '<span class="label">'. esc_html__('Seconds', BLOGINAC_TEXT_DOMAIN) .'</span>' : ''; ?>
                </div>
            </div>

            <script>
                (function() {
                    const countdownElement = document.getElementById('<?php echo esc_js($uniq_id); ?>');
                    const endDate = <?php echo esc_js($end_date); ?> * 1000;

                    function updateCountdown() {
                        const now = new Date().getTime();
                        const timeLeft = endDate - now;

                        if (timeLeft < 0) {
                            countdownElement.innerHTML = '<div>Countdown Ended</div>';
                            return;
                        }

                        const days = Math.floor(timeLeft / (1000 * 60 * 60 * 24));
                        const hours = Math.floor((timeLeft % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                        const minutes = Math.floor((timeLeft % (1000 * 60 * 60)) / (1000 * 60));
                        const seconds = Math.floor((timeLeft % (1000 * 60)) / 1000);

                        countdownElement.querySelector('.days').textContent = days.toString().padStart(2, '0');
                        countdownElement.querySelector('.hours').textContent = hours.toString().padStart(2, '0');
                        countdownElement.querySelector('.minutes').textContent = minutes.toString().padStart(2, '0');
                        countdownElement.querySelector('.seconds').textContent = seconds.toString().padStart(2, '0');
                    }

                    setInterval(updateCountdown, 1000);
                })();
            </script>
            <?php
        }
    }

endif;
