<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_CourseCTA')):

    /**
     * Elementor Carousel Widget.
     *
     * @class BLOGINAC_Elementor_CourseCTA
     * @version 1.0.0
     */
    class BLOGINAC_Elementor_CourseCTA extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-courseCTA';
        }

        public function get_title()
        {
            return __('Course CTA', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fas fa-mouse';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            (new BLOGINAC_Controls_Coursecta_Settings())->register_controls();
            (new BLOGINAC_Controls_Coursecta_Title())->register_controls();
            (new BLOGINAC_Controls_Coursecta_Items())->register_controls();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $section_title = !empty($settings['section_title']) ? $settings['section_title'] : __('We are with you with training', BLOGINAC_TEXT_DOMAIN);
            $cta_items = !empty($settings['cta_items']) ? $settings['cta_items'] : [];

            // No CTA Items Found
            if (!count($cta_items)) return;
?>
            <div class="bg-[var(--blg-color-primary500)] course-section w-full rounded-3xl lg:py-10 py-8 lg:px-8 px-4 grid xl:grid-cols-5 grid-cols-1 xl:gap-x-12 gap-y-8 items-center justify-center">
                <div class="flex flex-col max-w-max gap-y-2 col-span-1 items-center justify-center mx-auto course-post-title">
                    <h3 class="text-xl font-bold text-white w-full text-center"><?php echo esc_html($section_title); ?></h3>
                    <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                        <div class="h-[3px] rounded-lg bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px] blg-title-underline"></div>
                    </div>
                </div>
                <div class="lg:col-span-4 col-span-1">
                    <div class="flex w-full lg:flex-wrap overflow-x-auto xl:gap-x-6 gap-x-4 gap-y-4 flex-nowrap">
                        <?php foreach ($cta_items as $item): ?>
                            <div class="bg-[#2C3A4A] course-post-card hover:bg-[var(--blg-color-secondary200)] hover:text-white text-white rounded-[20px] flex items-center justify-center text-xs lg:text-base font-semibold text-center py-3 px-4 whitespace-nowrap lg:whitespace-normal min-w-[150px] lg:min-w-[unset]">
                                <a href="<?php echo esc_url($item['url']['url']); ?>" class="flex items-center gap-x-2 lg:gap-x-3" target="<?php echo esc_attr($item['url']['is_external'] ? '_blank' : '_self'); ?>" rel="<?php echo esc_attr($item['url']['nofollow'] ? 'nofollow' : ''); ?>">
                                    <?php if (!empty($item['icon']['url'])): ?>
                                        <img src="<?php echo esc_url($item['icon']['url']); ?>" alt="<?php echo esc_attr($item['title']); ?>" class="w-4 h-4 lg:w-6 lg:h-6" />
                                    <?php endif; ?>
                                    <?php if (!empty($item['icon']['value'])): ?>
                                        <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => 'w-4 h-4 lg:w-6 lg:h-6']); ?>
                                    <?php endif; ?>
                                    <span><?php echo esc_html($item['title']); ?></span>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>


<?php
        }
    }

endif;
