<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_FlipBox')):

    /**
     * Elementor Flip Box Widget.
     *
     * @class BLOGINAC_Elementor_FlipBox
     * @version 1.0.2
     */
    class BLOGINAC_Elementor_FlipBox extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-flipbox';
        }

        public function get_title()
        {
            return __('Blogina Flip Box', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'eicon-flip-box';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Tab
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('Content', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            $this->add_control(
                'front_title',
                [
                    'label' => __('Front Title', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('Front Title', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            $this->add_control(
                'front_description',
                [
                    'label' => __('Front Description', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                    'default' => __('This is the front description.', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            $this->add_control(
                'back_title',
                [
                    'label' => __('Back Title', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('Back Title', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            $this->add_control(
                'back_description',
                [
                    'label' => __('Back Description', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXTAREA,
                    'default' => __('This is the back description.', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            $this->add_control(
                'link',
                [
                    'label' => __('Link', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::URL,
                    'placeholder' => __('https://example.com', BLOGINAC_TEXT_DOMAIN),
                    'default' => [
                        'url' => '#',
                    ],
                ]
            );

            $this->end_controls_section();

            // Style Tab
            $this->start_controls_section(
                'style_section',
                [
                    'label' => __('Style', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            $this->add_control(
                'front_bg_color',
                [
                    'label' => __('Front Background Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#ffffff',
                    'selectors' => [
                        '{{WRAPPER}} .flip-box-front' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'back_bg_color',
                [
                    'label' => __('Back Background Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#f7f7f7',
                    'selectors' => [
                        '{{WRAPPER}} .flip-box-back' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => __('Title Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#333333',
                    'selectors' => [
                        '{{WRAPPER}} .flip-box h2' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'description_color',
                [
                    'label' => __('Description Color', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'default' => '#555555',
                    'selectors' => [
                        '{{WRAPPER}} .flip-box p' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'border_radius',
                [
                    'label' => __('Border Radius', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => ['px', '%'],
                    'range' => [
                        'px' => ['min' => 0, 'max' => 50],
                    ],
                    'default' => ['size' => 10],
                    'selectors' => [
                        '{{WRAPPER}} .flip-box' => 'border-radius: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .flip-box-front, {{WRAPPER}} .flip-box-back' => 'border-radius: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $front_title = $settings['front_title'] ?? '';
            $front_description = $settings['front_description'] ?? '';
            $back_title = $settings['back_title'] ?? '';
            $back_description = $settings['back_description'] ?? '';
            $link = $settings['link']['url'] ?? '#';

            ?>
            <div class="flip-box">
                <div class="flip-box-inner">
                    <div class="flip-box-front">
                        <h2><?php echo esc_html($front_title); ?></h2>
                        <p><?php echo esc_html($front_description); ?></p>
                    </div>
                    <div class="flip-box-back">
                        <h2><?php echo esc_html($back_title); ?></h2>
                        <p><?php echo esc_html($back_description); ?></p>
                        <a href="<?php echo esc_url($link); ?>" class="flip-box-link"><?php _e('Learn More', BLOGINAC_TEXT_DOMAIN); ?></a>
                    </div>
                </div>
            </div>
            <?php
        }
    }

endif;
