<?php
// no direct access
defined('ABSPATH') || die();

class BLOGINAC_Elementor_FloatVideo extends BLOGINAC_Elementor_Base
{
    public function get_name()
    {
        return 'bloginac-video-button';
    }

    public function get_title()
    {
        return __('Float Video', BLOGINAC_TEXT_DOMAIN);
    }

    public function get_icon()
    {
        return 'fa fa-video';
    }

    public function get_categories()
    {
        return ['blogina'];
    }

    protected function register_controls()
    {
        // Content Controls
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Settings', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Video URL
        $this->add_control(
            'video_url',
            [
                'label' => __('Video URL', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('Enter YouTube, Vimeo, or Self-hosted Video URL', BLOGINAC_TEXT_DOMAIN),
                'default' => [
                    'url' => '',
                ],
            ]
        );

        // Button Label
        $this->add_control(
            'button_label',
            [
                'label' => __('Button Label', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Play Video', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // Autoplay Option
        $this->add_control(
            'autoplay',
            [
                'label' => __('Autoplay', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'default' => 'yes',
            ]
        );

        // Show Controls Option
        $this->add_control(
            'controls',
            [
                'label' => __('Show Controls', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'default' => 'yes',
            ]
        );

        // Position Type
        $this->add_control(
            'position_type',
            [
                'label' => __('Position Type', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'fixed' => __('Floating (Fixed)', BLOGINAC_TEXT_DOMAIN),
                    'unset' => __('stay still', BLOGINAC_TEXT_DOMAIN),
                ],
                'default' => 'fixed',
            ]
        );

        // Show Play Icon
        $this->add_control(
            'show_icon',
            [
                'label' => __('Show Play Icon', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        // Style Controls
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('Button Style', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Button Background Color
        $this->add_control(
            'button_bg_color',
            [
                'label' => __('Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF0000',
                'selectors' => [
                    '{{WRAPPER}} .floating-video-button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // Button Text Color
        $this->add_control(
            'button_text_color',
            [
                'label' => __('Text Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
                'selectors' => [
                    '{{WRAPPER}} .floating-video-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $video_url = $settings['video_url']['url'];
        $button_label = $settings['button_label'];
        $autoplay = $settings['autoplay'] === 'yes' ? 'true' : 'false';
        $controls = $settings['controls'] === 'yes' ? 'true' : 'false';
        $position_type = $settings['position_type'];
        $show_icon = $settings['show_icon'] === 'yes';

        if (empty($video_url))
        {
            echo '<p style="color: red;">Please provide a video URL in the widget settings.</p>';
            return;
        }

        ?>
        <div class="blgelm-floating-video-container">
            <!-- Floating Button -->
            <button class="floating-video-button"
                    style="position: <?php echo esc_attr($position_type); ?>;"
                    onclick="video_modal('<?php echo esc_js($video_url); ?>', <?php echo esc_js($controls); ?>, <?php echo esc_js($autoplay); ?>)">
                <?php if ($show_icon) : ?>
                    <i class="fas fa-play play-icon"></i>
                <?php endif; ?>
                <?php //echo esc_html($button_label);
                ?>
            </button>
        </div>
        <?php
    }
}
