<?php
// Prevent direct access
defined('ABSPATH') || exit;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

/**
 * Elementor Menu and Mega Menu Widget
 */
class Custom_Menu_Widget extends Widget_Base
{
    public function get_name()
    {
        return 'custom_menu';
    }

    public function get_title()
    {
        return __('Menu & Mega Menu', 'custom-elementor');
    }

    public function get_icon()
    {
        return 'eicon-nav-menu';
    }

    public function get_categories()
    {
        return ['basic'];
    }

    public function register_controls()
    {
        // General Section
        $this->start_controls_section(
            'general_settings',
            [
                'label' => __('General Settings', 'custom-elementor'),
            ]
        );

        $this->add_control(
            'menu',
            [
                'label' => __('Select Menu', 'custom-elementor'),
                'type' => Controls_Manager::SELECT,
                'options' => $this->get_available_menus(),
                'description' => __('Select the menu to display.', 'custom-elementor'),
            ]
        );

        $this->add_control(
            'enable_mega_menu',
            [
                'label' => __('Enable Mega Menu', 'custom-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'custom-elementor'),
                'label_off' => __('No', 'custom-elementor'),
                'default' => 'no',
            ]
        );

        $this->end_controls_section();

        // Style Section
        $this->start_controls_section(
            'menu_styles',
            [
                'label' => __('Menu Styles', 'custom-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'menu_background',
            [
                'label' => __('Background Color', 'custom-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .custom-menu' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'menu_item_color',
            [
                'label' => __('Item Color', 'custom-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .custom-menu a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'menu_item_hover_color',
            [
                'label' => __('Item Hover Color', 'custom-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .custom-menu a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $menu_id = $settings['menu'];

        if (empty($menu_id)) {
            echo __('No menu selected.', 'custom-elementor');
            return;
        }

        // Render the menu
        echo '<nav class="custom-menu">';
        wp_nav_menu([
            'menu' => $menu_id,
            'container' => '',
            'menu_class' => 'menu',
            'walker' => $settings['enable_mega_menu'] === 'yes' ? new Custom_Mega_Menu_Walker() : '',
        ]);
        echo '</nav>';
    }

    private function get_available_menus()
    {
        $menus = wp_get_nav_menus();
        $options = [];

        foreach ($menus as $menu) {
            $options[$menu->term_id] = $menu->name;
        }

        return $options;
    }
}

/**
 * Custom Mega Menu Walker
 * Handles the rendering of mega menu items.
 */
class Custom_Mega_Menu_Walker extends Walker_Nav_Menu
{
    public function start_lvl(&$output, $depth = 0, $args = null)
    {
        $classes = ['sub-menu'];
        if ($depth === 0) {
            $classes[] = 'mega-menu';
        }
        $class_names = implode(' ', $classes);
        $output .= "<ul class='$class_names'>";
    }
}
