<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Popup')) :

    /**
     * Elementor Popup Form Widget.
     *
     * @class BLOGINAC_Elementor_Popup
     * @version 1.0.0
     */
    class BLOGINAC_Elementor_Popup extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-popup-form';
        }

        public function get_title()
        {
            return __('Popup Form', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'eicon-popup';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Section
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('Popup Form Settings', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            // Button Text
            $this->add_control(
                'button_text',
                [
                    'label' => __('Button Text', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('Open Form', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            // Form Heading
            $this->add_control(
                'form_heading',
                [
                    'label' => __('Form Heading', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('Contact Us', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            // Form Fields (using repeater)
            $this->add_control(
                'form_fields',
                [
                    'label' => __('Form Fields', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => [
                        [
                            'name' => 'field_label',
                            'label' => __('Field Label', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => __('Your Name', BLOGINAC_TEXT_DOMAIN),
                        ],
                        [
                            'name' => 'field_type',
                            'label' => __('Field Type', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'text' => __('Text', BLOGINAC_TEXT_DOMAIN),
                                'email' => __('Email', BLOGINAC_TEXT_DOMAIN),
                                'textarea' => __('Textarea', BLOGINAC_TEXT_DOMAIN),
                            ],
                            'default' => 'text',
                        ],
                    ],
                    'title_field' => '{{{ field_label }}}',
                ]
            );

            $this->end_controls_section();

            // Style Section
            $this->start_controls_section(
                'style_section',
                [
                    'label' => __('Style', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            // Button Style
            $this->add_control(
                'button_style',
                [
                    'label' => __('Button Style', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'solid',
                    'options' => [
                        'solid' => __('Solid', BLOGINAC_TEXT_DOMAIN),
                        'outline' => __('Outline', BLOGINAC_TEXT_DOMAIN),
                    ],
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $button_text = $settings['button_text'];
            $form_heading = $settings['form_heading'];
            $form_fields = $settings['form_fields'];

            // Generate Unique ID for the widget instance
            $uniq_id = uniqid('bloginac-popup-form-');

            ?>
            <!-- Popup Trigger Button -->
            <button class="popup-form-trigger" id="<?php echo esc_attr($uniq_id); ?>-trigger">
                <?php echo esc_html($button_text); ?>
            </button>

            <!-- Popup Form Modal -->
            <div class="popup-form-modal" id="<?php echo esc_attr($uniq_id); ?>" style="display: none;">
                <div class="popup-form-content">
                    <span class="popup-form-close" id="<?php echo esc_attr($uniq_id); ?>-close">&times;</span>
                    <h2><?php echo esc_html($form_heading); ?></h2>
                    <form class="popup-form">
                        <?php foreach ($form_fields as $field) : ?>
                            <div class="form-group">
                                <label><?php echo esc_html($field['field_label']); ?></label>
                                <?php if ($field['field_type'] === 'textarea') : ?>
                                    <textarea name="<?php echo sanitize_title($field['field_label']); ?>" required></textarea>
                                <?php else : ?>
                                    <input type="<?php echo esc_attr($field['field_type']); ?>" name="<?php echo sanitize_title($field['field_label']); ?>" required />
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                        <button type="submit" class="submit-btn">Submit</button>
                    </form>
                </div>
            </div>

            <script>
                (function ($) {
                    $(document).ready(function () {
                        var popupId = '#<?php echo esc_attr($uniq_id); ?>';
                        var trigger = $('#<?php echo esc_attr($uniq_id); ?>-trigger');
                        var modal = $(popupId);
                        var closeBtn = $('#<?php echo esc_attr($uniq_id); ?>-close');

                        trigger.click(function () {
                            modal.show();
                        });

                        closeBtn.click(function () {
                            modal.hide();
                        });

                        // Close modal when clicking outside the popup
                        $(window).click(function (event) {
                            if ($(event.target).is(modal)) {
                                modal.hide();
                            }
                        });
                    });
                })(jQuery);
            </script>

            <style>
                .popup-form-modal {
                    position: fixed;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 100%;
                    background-color: rgba(0, 0, 0, 0.5);
                    display: none;
                    justify-content: center;
                    align-items: center;
                }

                .popup-form-content {
                    background-color: white;
                    padding: 20px;
                    width: 400px;
                    border-radius: 8px;
                    position: relative;
                }

                .popup-form-close {
                    position: absolute;
                    top: 10px;
                    right: 10px;
                    font-size: 30px;
                    cursor: pointer;
                }

                .form-group {
                    margin-bottom: 15px;
                }

                .form-group label {
                    display: block;
                    margin-bottom: 5px;
                }

                .form-group input,
                .form-group textarea {
                    width: 100%;
                    padding: 8px;
                    border: 1px solid #ccc;
                    border-radius: 4px;
                    box-sizing: border-box;
                }

                .submit-btn {
                    background-color: #007bff;
                    color: white;
                    padding: 10px 15px;
                    border: none;
                    border-radius: 4px;
                    cursor: pointer;
                }

                .submit-btn:hover {
                    background-color: #0056b3;
                }
            </style>
            <?php
        }
    }

endif;
