<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_Search')) :

    /**
     * Elementor Search Widget.
     *
     * @class BLOGINAC_Elementor_Search
     * @version 1.0.0
     */
    class BLOGINAC_Elementor_Search extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-search';
        }

        public function get_title()
        {
            return __('Search', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fas fa-search';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Section
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('Search Settings', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            // Placeholder Text
            $this->add_control(
                'placeholder_text',
                [
                    'label' => __('Placeholder Text', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('Search...', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            // Button Text
            $this->add_control(
                'button_text',
                [
                    'label' => __('Button Text', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __('Search', BLOGINAC_TEXT_DOMAIN),
                ]
            );

            $this->end_controls_section();

            // Style Section
            $this->start_controls_section(
                'style_section',
                [
                    'label' => __('Style', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );
            
            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $placeholder_text = $settings['placeholder_text'];
            $button_text = $settings['button_text'];

            // Generate Unique ID for the widget instance
            $uniq_id = uniqid('bloginac-search-');

            ?>
            <div id="<?php echo esc_attr($uniq_id); ?>" class="bloginac-search-widget">
                <form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>" class="search-form">
                    <input type="text" name="s" placeholder="<?php echo esc_attr($placeholder_text); ?>" class="search-input" />
                    <button type="submit" class="search-button">
                        <?php echo esc_html($button_text); ?>
                    </button>
                </form>
            </div>
            <?php
        }
    }

endif;
