<?php
// no direct access
defined('ABSPATH') || die();

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

/**
 * Addon Widgets Class.
 *
 * @class BLOGINAC_Elementor_Single
 * @version    1.0.0
 */
abstract class BLOGINAC_Elementor_Single extends Widget_Base
{
    /**
     * @inheritDoc
     */
    public function get_name()
    {
        return ''; // Provide a default name or override in child classes
    }

    public function get_categories(): array
    {
        return ['blogina-single'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'listdom-elementor'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'heading',
            [
                'type' => Controls_Manager::RAW_HTML,
                'raw' => '<p>' . __('No Options', 'listdom-elementor') . '</p>',
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Get the course post.
     *
     * @return BLOGINAC_Entity_Course|null The course entity or null if not found.
     */
    public function get_course()
    {
        // Get the current post ID
        $post_id = get_the_ID();

        // Ensure it's a valid course post type
        if (!$post_id || get_post_type($post_id) !== BLOGINAC_Base::PTYPE_COURSE) {
            return null;
        }

        // Return an instance of BLOGINAC_Entity_Course
        return new BLOGINAC_Entity_Course($post_id);
    }

    /**
     * Render the course content.
     */
    protected function render()
    {
        // Get the course
        $course = $this->get_course();

        // Ensure we have a valid course before rendering
        if (!$course) {
            echo '<p>' . __('No course found.', 'listdom-elementor') . '</p>';
            return;
        }

        // Output the course content using the abstract method
        echo $this->course($course);
    }

    /**
     * Abstract method to be implemented in child classes.
     *
     * @param BLOGINAC_Entity_Course $course The course entity.
     * @return string The rendered content.
     */
    abstract protected function course(BLOGINAC_Entity_Course $course): string;
}
