<?php
// no direct access
defined('ABSPATH') || die();

if (!class_exists('BLOGINAC_Elementor_VGallery')):

    /**
     * Elementor Video Gallery Widget.
     *
     * @class BLOGINAC_Elementor_VGallery
     * @version 1.0.0
     */
    class BLOGINAC_Elementor_VGallery extends BLOGINAC_Elementor_Base
    {
        public function get_name()
        {
            return 'bloginac-video-gallery';
        }

        public function get_title()
        {
            return __('Blogina Video Gallery', BLOGINAC_TEXT_DOMAIN);
        }

        public function get_icon()
        {
            return 'fas fa-photo-video';
        }

        public function get_categories()
        {
            return ['blogina'];
        }

        protected function register_controls()
        {
            // Content Section
            $this->start_controls_section(
                'content_section',
                [
                    'label' => __('Gallery Settings', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                ]
            );

            // Video Gallery URLs Control
            $this->add_control(
                'gallery_videos',
                [
                    'label' => __('Video URLs', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => [
                        [
                            'name' => 'video_url',
                            'label' => __('Video URL', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::URL,
                            'placeholder' => __('Enter YouTube, Vimeo, or Self-hosted Video URL', BLOGINAC_TEXT_DOMAIN),
                        ],
                        [
                            'name' => 'video_caption',
                            'label' => __('Caption', BLOGINAC_TEXT_DOMAIN),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'placeholder' => __('Enter video caption (optional)', BLOGINAC_TEXT_DOMAIN),
                        ]
                    ],
                    'default' => [],
                ]
            );

            // Layout Options
            $this->add_control(
                'layout',
                [
                    'label' => __('Layout', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'grid',
                    'options' => [
                        'grid' => __('Grid', BLOGINAC_TEXT_DOMAIN),
                        'masonry' => __('Masonry', BLOGINAC_TEXT_DOMAIN),
                    ],
                ]
            );

            // Grid and Masonry Column Control
            $this->add_control(
                'columns',
                [
                    'label' => __('Columns', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => '3',
                    'options' => [
                        '1' => __('1 Column', BLOGINAC_TEXT_DOMAIN),
                        '2' => __('2 Columns', BLOGINAC_TEXT_DOMAIN),
                        '3' => __('3 Columns', BLOGINAC_TEXT_DOMAIN),
                        '4' => __('4 Columns', BLOGINAC_TEXT_DOMAIN),
                        '5' => __('5 Columns', BLOGINAC_TEXT_DOMAIN),
                    ],
                    'condition' => [
                        'layout' => ['grid', 'masonry'],
                    ],
                ]
            );

            // Spacing Control
            $this->add_control(
                'spacing',
                [
                    'label' => __('Spacing Between Videos', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 50,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-video-gallery-wrapper' => 'grid-gap: {{SIZE}}px;',
                    ],
                ]
            );

            // Hover Effect
            $this->add_control(
                'hover_effect',
                [
                    'label' => __('Hover Effect', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => 'zoom',
                    'options' => [
                        'zoom' => __('Zoom', BLOGINAC_TEXT_DOMAIN),
                        'fade' => __('Fade', BLOGINAC_TEXT_DOMAIN),
                        'none' => __('None', BLOGINAC_TEXT_DOMAIN),
                    ],
                ]
            );

            // Enable Lightbox
            $this->add_control(
                'lightbox',
                [
                    'label' => __('Enable Lightbox', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                    'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                    'default' => 'yes',
                ]
            );

            $this->end_controls_section();

            // Style Section
            $this->start_controls_section(
                'style_section',
                [
                    'label' => __('Style', BLOGINAC_TEXT_DOMAIN),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                ]
            );

            // Video Item Border Radius
            $this->add_control(
                'border_radius',
                [
                    'label' => __('Video Border Radius', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 50,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 5,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .bloginac-video-gallery-item iframe' => 'border-radius: {{SIZE}}px;',
                    ],
                ]
            );

            // Video Caption Style
            $this->add_control(
                'caption_style',
                [
                    'label' => __('Caption Style', BLOGINAC_TEXT_DOMAIN),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => 'text-align: center; color: #fff;',
                ]
            );

            $this->end_controls_section();
        }

        protected function render()
        {
            $settings = $this->get_settings_for_display();
            $gallery_videos = $settings['gallery_videos'];
            $layout = $settings['layout'];
            $columns = $settings['columns'];
            $spacing = $settings['spacing']['size'] ?? 10;
            $hover_effect = $settings['hover_effect'];
            $lightbox = $settings['lightbox'] === 'yes' ? true : false;
            $caption_style = $settings['caption_style'];

            // Add classes for layout and column setting
            $layout_class = $layout === 'grid' ? 'bloginac-grid' : 'bloginac-masonry';
            $columns_class = 'bloginac-columns-' . $columns;

            // Start Gallery HTML
            echo '<div class="bloginac-video-gallery-wrapper ' . esc_attr($layout_class) . ' ' . esc_attr($columns_class) . '" style="grid-gap: ' . esc_attr($spacing) . 'px;">';

            foreach ($gallery_videos as $video) {
                $video_url = $video['video_url']['url'];
                $video_caption = $video['video_caption'];

                // Lightbox support for YouTube/Vimeo
                $lightbox_attr = $lightbox ? 'data-fancybox="gallery"' : '';

                echo '<div class="bloginac-video-gallery-item" style="position: relative;">';

                // Embed the video (YouTube, Vimeo, or custom video)
                if (strpos($video_url, 'youtube') !== false || strpos($video_url, 'vimeo') !== false) {
                    echo '<iframe src="' . esc_url($video_url) . '" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen style="width: 100%; height: auto; transition: transform 0.3s;"></iframe>';
                } else {
                    echo '<video class="plyr" src="' . esc_url($video_url) . '" controls style="width: 100%; height: auto; transition: transform 0.3s;"></video>';
                }

                if ($hover_effect === 'zoom') {
                    echo '<style>
                            .bloginac-video-gallery-item:hover iframe, .bloginac-video-gallery-item:hover video {
                                transform: scale(1.1);
                            }
                          </style>';
                } elseif ($hover_effect === 'fade') {
                    echo '<style>
                            .bloginac-video-gallery-item:hover iframe, .bloginac-video-gallery-item:hover video {
                                opacity: 0.8;
                            }
                          </style>';
                }

                // Display caption
                if ($video_caption) {
                    echo '<div class="video-caption" style="' . esc_attr($caption_style) . '">' . esc_html($video_caption) . '</div>';
                }

                echo '</div>';
            }

            echo '</div>';

            echo '<script>
        document.addEventListener("DOMContentLoaded", function() {
            const players = Array.from(document.querySelectorAll(".plyr")).map(video => new Plyr(video));
        });
    </script>';
        }
    }

endif;
