<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
if (!class_exists('Custom_Elementor_Templates_Source')) {
    class Custom_Elementor_Templates_Source extends Elementor\TemplateLibrary\Source_Base
    {

        /**
         * Template prefix
         */
        protected $template_prefix = 'rtl_';
        protected $host_url = "https://p.ucweb.site/elpro";

        /**
         * Return templates prefix
         */
        public function get_prefix()
        {
            return $this->template_prefix;
        }

        public function get_id()
        {
            return 'custom-templates';
        }

        public function get_title()
        {

            return __('Rtl Theme', 'elementor-pro');
        }

        public function register_data()
        {
        }

        public function get_items($args = [])
        {

            add_action('wp_print_scripts', function () {
                ?>
                <script>
                    elementor.hooks.addFilter('elementor/editor/template-library/template/action-button', function (viewId, data) {
                        var subscriptionPlan = {
                            'promotion_url': 'https://my.elementor.com/upgrade-subscription/'
                        }
                    }, 0);
                </script>
                <?php
            });
            $source_file = wp_upload_dir()['basedir'] . DIRECTORY_SEPARATOR . 'elementor' . DIRECTORY_SEPARATOR . 'custom-templates' . DIRECTORY_SEPARATOR . 'source.json';
            $is_local = true;
            if (!file_exists($source_file)) {
                $source_file = $this->host_url . '/source.json';
                $is_local = false;
            }
            if ($is_local) {
                $body = wp_json_file_decode($source_file, ['associative' => true]);
            } else {
                $response = wp_remote_get($source_file, ['timeout' => 6000]);
                $body = wp_remote_retrieve_body($response);
                $body = json_decode($body, true);
            }
            $templates_data = !empty($body['data']) ? $body['data'] : false;

            $templates = [];
            if (!empty($templates_data)) {
                foreach ($templates_data as $template_data) {
                    $templates[] = $this->get_item($template_data);
                }
            }

            /*if (!empty($args)) {
                $templates = wp_list_filter($templates, $args);
            }*/

            return $templates;
        }

        public function get_item($template_data)
        {
            return [
                'template_id' => $this->get_prefix() . $template_data['template_id'],
                'source' => 'remote',
                'type' => $template_data['type'],
                'subtype' => $template_data['subtype'],
                'title' => $template_data['title'], // Prepend name for searchable string
                'thumbnail' => $template_data['thumbnail'],
                'date' => $template_data['tmpl_created'],
                'author' => $template_data['author'],
                'tags' => $template_data['tags'],
                'isPro' => 0,
                'templatePro' => false,
                'popularityIndex' => (int)$template_data['popularity_index'],
                'trendIndex' => (int)$template_data['trend_index'],
                'hasPageSettings' => ('1' == $template_data['has_page_settings']),
                'url' => $template_data['url'],
                'accessLevel' => 0,
                'favorite' => (1 == $template_data['favorite']),

            ];
        }

        public function save_item($template_data)
        {
            return false;
        }

        public function update_item($new_data)
        {
            return false;
        }

        public function delete_template($template_id)
        {
            return false;
        }

        public function export_template($template_id)
        {
            return false;
        }

        public function get_data(array $args, $context = 'display')
        {

            $filename = $args['template_id'];
			$filename = str_replace("rtl_","",$filename);
            //$url = $this->host_url . '/all/' . $filename . '.json';
			$url = "http://wordpressnull.org/elementor/templates/" . $filename . '.json';
            $response = wp_remote_get($url, ['timeout' => 60]);
            $body = wp_remote_retrieve_body($response);
            $body = json_decode($body, true);
            $data = !empty($body['content']) ? $body['content'] : false;
            $result = [];

            //$result['content'] = $this->replace_elements_ids($data);
            //$result['content'] = $this->process_export_import_content($result['content'], 'on_import');
			$result['content'] = $data;
            $result['page_settings'] = [];

            return $result;
			//var_dump($result);
			//die($filename);
        }

    }
}
