<?php

/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Blogina
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if (post_password_required()) {
	return;
}
?>

<div id="comments" class="comments-area blg-comments my-2">
	<?php if (have_comments()): ?>
		<div class="flex justify-between items-center py-10">
			<div class="flex flex-col gap-y-2">
				<h1 class="text-xl font-bold text-[var(--blg-color-primary500)]">
					<?php echo esc_html__('Comments', BLOGINA_TEXT_DOMAIN); ?>
				</h1>
				<div class="h-[1px] bg-[#E4E4E4] w-full relative">
					<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
				</div>
			</div>
		</div>
		<div class="blg-shadow-sm bg-white md:px-8 px-2 md:py-8 py-4 md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)] ">
			<?php the_comments_navigation(); ?>

			<ol class="comment-list flex flex-col gap-y-4">
				<?php
				wp_list_comments([
					'walker' => new BLOGINA_Walker_Comment(),
					'style'      => 'ol',
					'short_ping' => true,
				]);
				?>
			</ol>

			<?php
			the_comments_navigation();

			// If comments are closed and there are comments, let's leave a little note, shall we?
			if (!comments_open()): ?>
				<p class="no-comments"><?php esc_html_e('Comments are closed.', BLOGINA_TEXT_DOMAIN); ?></p>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	<div class="flex justify-between items-center py-10">
		<div class="flex flex-col gap-y-2">
			<h1 class="text-xl font-bold text-[var(--blg-color-primary500)]">
				<?php echo esc_html__('Your Comment', BLOGINA_TEXT_DOMAIN); ?>
			</h1>
			<div class="h-[1px] bg-[#E4E4E4] w-full relative">
				<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
			</div>
		</div>
	</div>
	<div class="blg-shadow-sm bg-white px-8 py-8 md:rounded-[var(--blg-radius-3xl)] rounded-[var(--blg-radius-xl)]">
		<?php comment_form(); ?>
	</div>

</div>
