<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Blogina
 */

$after_header = BLOGINA_Settings::get('blogina_after_header', '');
$preloader = BLOGINA_Settings::get('blg_activate_preloading');
$fullwidth = BLOGINA_Settings::get('blg_site_width_style') === 'full-width';
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
    <?php if ($after_header && trim($after_header)) echo $after_header; ?>

    <style>
        :root {
        <?php echo $fullwidth && is_front_page() ? '--blg-site-width:100%': ''; ?>
        }
    </style>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<?php if ($preloader) BLOGINA_Headers::preloader(); ?>

<div id="page" class="site blogina-container <?php echo $fullwidth && !is_front_page() ? 'max-w-[1300px] px-4': ''; ?><?php echo $fullwidth ? '': 'px-4'; ?>">

    <?php
    // Header Inclusion
    BLOGINA_Headers::display();
    ?>

    <div class="" id="primary">
