<?php
$price = BLOGINA_Course::get_price(true);
$display_stars = BLOGINA_Settings::get('blg_show_review_stars');
$display_regular_price = BLOGINA_Settings::get('blg_show_regular_price');
$display_sale_price = BLOGINA_Settings::get('blg_show_sale_price');
$display_mentor = BLOGINA_Settings::get('blg_show_mentor');
$display_tags = BLOGINA_Settings::get('blg_show_tags');
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('blg-shadow-sm flex flex-row items-center md:gap-x-6 gap-x-4 md:p-4 p-2 rounded-[var(--blg-radius-3xl)] bg-white hover:border-t-2 hover:border-[var(--blg-color-secondary200)] transition-all duration-75'); ?>>
    <!-- Thumbnail -->
    <?php if (has_post_thumbnail()): ?>
        <div class="bg-[var(--blg-color-primary400)] md:rounded-[20px] rounded-md md:w-[40%] w-[30%] h-full overflow-hidden">
            <a href="<?php the_permalink(); ?>" aria-label="course" class="h-full flex">
                <img width="100%" height="100%" class="md:rounded-[20px] rounded-md w-full !h-full object-cover"
                     src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title_attribute(); ?>">
            </a>
        </div>
    <?php else: ?>
        <div class="bg-[var(--blg-color-primary400)] md:rounded-[20px] rounded-md md:w-[40%] w-[30%] h-full overflow-hidden">
            <a href="<?php the_permalink(); ?>" aria-label="course" class="h-full flex">
                <img width="100%" height="100%" class="md:rounded-[20px] rounded-md w-full !h-full object-cover"
                     src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp"
                     alt="<?php the_title_attribute(); ?>">
            </a>
        </div>
    <?php endif; ?>

    <!-- Content -->
    <div class="flex flex-col justify-between flex-grow md:gap-y-3 gap-y-4">
        <div class="flex flex-col md:gap-y-3 gap-y-4">
            <!-- Title and Mentor -->
            <div class="flex flex-col md:gap-y-2 gap-y-3">
                <div class="flex md:flex-row flex-col md:items-center justify-between md:gap-y-0 gap-y-2">
                    <div class="flex  items-center gap-x-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
                            <circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)"/>
                        </svg>
                        <h4 class="md:text-lg text-md font-bold text-[var(--blg-color-primary500)]"><?php the_title(); ?></h4>
                    </div>
                    <?php if ($display_stars): ?>
                        <div class="flex items-center">
                            <?php echo BLOGINA_Course::get_rating(); ?>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if ($display_mentor): ?>
                    <div class="flex gap-x-1 items-center">
                        <?php echo BLOGINA_User::get_avatar(get_the_ID(), 24, '', 'mentor'); ?>
                        <span class="text-sm font-medium text-[var(--blg-gray)]"><span>مدرس: </span><?php echo BLOGINA_Course::get_mentor(); ?></span>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Tags -->
            <?php if($display_tags): ?>
                <div class="flex gap-x-2">
                    <?php echo BLOGINA_Post::tags(3, BLOGINAC_Base::TAX_COURSE_TAG); ?>
                </div>
            <?php endif; ?>
        </div>
        <?php
        global $product;
        ?>

        <!-- Rating and Price -->
        <div class="flex md:items-center justify-between mt-2">
            <div class="flex items-center gap-x-2">
                <?php if ($display_sale_price && $price['sale_price']): ?>
                    <div class="text-[var(--blg-gray)] font-medium text-sm">
                        <del><?php echo BLOGINA_Course::short_price($price['regular_price']); ?></del>
                    </div>
                    <?php if ($price['sale_price'] && $price['regular_price'] && $display_regular_price): ?>
                        <div class="w-[1px] h-[15px] bg-[var(--blg-color-primary500)] opacity-50 mx-1"></div>
                    <?php endif; ?>
                    <div class="text-[var(--blg-color-secondary200)] font-medium text-sm"><?php echo BLOGINA_Course::short_price($price['sale_price']); ?></div>
                <?php elseif ($display_regular_price): ?>
                    <div class="text-[var(--blg-color-secondary200)] font-medium text-sm"><?php echo BLOGINA_Course::short_price($price['regular_price']); ?></div>
                <?php endif; ?>

                <?php if ($display_regular_price || $display_sale_price): ?>
                    <?php if (!BLOGINA_Course::is_product_free($product)): ?>
                        <div class="text-[#858585] text-sm font-['YekanBakh']"><?php echo BLOGINA_Course::get_currency(); ?></div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            <!-- Add to Cart Button -->
            <div class="flex justify-end">
                <button aria-label="Add to Cart" type="submit"
                        class="blg-btn-secondary !p-2 !rounded-lg flex gap-x-2 items-center add_to_cart_button ajax_add_to_cart"
                        data-product_id="<?php echo the_ID(); ?>" data-quantity="1">
                    خرید
                    <div class="bg-white rounded-md p-1.5">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
                            <path opacity="0.4"
                                  d="M16.0337 4.64997H15.7003L12.8837 1.8333C12.6587 1.6083 12.292 1.6083 12.0587 1.8333C11.8337 2.0583 11.8337 2.42497 12.0587 2.6583L14.0503 4.64997H5.95032L7.94199 2.6583C8.16699 2.4333 8.16699 2.06663 7.94199 1.8333C7.71699 1.6083 7.35032 1.6083 7.11699 1.8333L4.30866 4.64997H3.97533C3.22533 4.64997 1.66699 4.64997 1.66699 6.7833C1.66699 7.59163 1.83366 8.12497 2.18366 8.47497C2.38366 8.6833 2.62533 8.79163 2.88366 8.84997C3.12533 8.9083 3.38366 8.91663 3.63366 8.91663H16.367C16.6253 8.91663 16.867 8.89997 17.1003 8.84997C17.8003 8.6833 18.3337 8.1833 18.3337 6.7833C18.3337 4.64997 16.7753 4.64997 16.0337 4.64997Z"
                                  fill="var(--blg-color-secondary200)"/>
                            <path d="M16.3755 8.91676H3.63379C3.38379 8.91676 3.12546 8.90843 2.88379 8.8501L3.93379 15.2501C4.16712 16.6834 4.79212 18.3334 7.56712 18.3334H12.2421C15.0505 18.3334 15.5505 16.9251 15.8505 15.3501L17.1088 8.8501C16.8755 8.9001 16.6255 8.91676 16.3755 8.91676ZM8.84212 14.3001C8.84212 14.6251 8.58379 14.8834 8.25879 14.8834C7.93379 14.8834 7.67546 14.6251 7.67546 14.3001V11.5501C7.67546 11.2251 7.93379 10.9668 8.25879 10.9668C8.58379 10.9668 8.84212 11.2251 8.84212 11.5501V14.3001ZM12.4088 14.3001C12.4088 14.6251 12.1505 14.8834 11.8255 14.8834C11.5005 14.8834 11.2421 14.6251 11.2421 14.3001V11.5501C11.2421 11.2251 11.5005 10.9668 11.8255 10.9668C12.1505 10.9668 12.4088 11.2251 12.4088 11.5501V14.3001Z"
                                  fill="var(--blg-color-secondary200)"/>
                        </svg>
                    </div>
                </button>
            </div>
        </div>


    </div>
</article>
