<?php
$price = BLOGINA_Course::get_price(true);
$display_stars = BLOGINA_Settings::get('blg_show_review_stars');
$display_regular_price = BLOGINA_Settings::get('blg_show_regular_price');
$display_sale_price = BLOGINA_Settings::get('blg_show_sale_price');
$display_mentor = BLOGINA_Settings::get('blg_show_mentor');
$display_tags = BLOGINA_Settings::get('blg_show_tags');
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('blg-shadow-sm flex flex-col gap-y-5 rounded-[var(--blg-radius-3xl)] bg-white lg:p-6 p-4 hover:border-t-2 hover:border-[var(--blg-color-secondary200)] transition-all duration-75'); ?>>
	<div class="relative">
		<a href="<?php the_permalink(); ?>" class="w-full" aria-label="course">

			<header role="banner" class="entry-header">
				<?php if (has_post_thumbnail()): ?>
					<div class="blg_course_grid">
						<div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
							<img class="!max-h-[226px] !min-h-[226px]" loading="lazy" decoding="async" width="100%" height="100%" src="<?php echo the_post_thumbnail_url(); ?>" alt="">
						</div>
						<a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>" class="get_more">
							<svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7" xmlns="http://www.w3.org/2000/svg" width="29" height="29" viewBox="0 0 29 29" fill="none">
								<path opacity="0.4" d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z" fill="var(--blg-color-primary500)" />
								<path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z" fill="var(--blg-color-primary500)" />
							</svg>
						</a>
					</div>
				<?php else: ?>
					<div class="blg_course_grid">
						<div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
							<img class="!max-h-[226px] !min-h-[226px]" loading="lazy" decoding="async" width="100%" height="100%" src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="">
						</div>
						<a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>" class="get_more">
							<svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7" xmlns="http://www.w3.org/2000/svg" width="29" height="29" viewBox="0 0 29 29" fill="none">
								<path opacity="0.4" d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z" fill="var(--blg-color-primary500)" />
								<path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z" fill="var(--blg-color-primary500)" />
							</svg>
						</a>
					</div>
				<?php endif; ?>
				<div class="flex flex-col gap-y-3 mt-4">
					<div class="w-full flex items-center justify-between">
                        <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>">
                            <div class="!flex !gap-x-1 !items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="6" height="6" viewBox="0 0 6 6" fill="none">
                                    <circle cx="2.87549" cy="2.58203" r="2.5" fill="var(--blg-color-secondary200)" />
                                </svg>
                                <h4 class="md:text-base text-[15px] font-bold text-[var(--blg-color-primary500)]"><?php the_title(); ?></h4>
                            </div>
                        </a>
						<?php echo BLOGINA_Course::get_rating(); ?>
					</div>
				</div>
			</header>
		</a>
		<div class="w-full flex items-center justify-between gap-x-2 mt-3">

            <?php if($display_tags): ?>
                <div class="flex w-full gap-x-3">
                    <?php echo BLOGINA_Post::tags(2, BLOGINAC_Base::TAX_COURSE_TAG); ?>
                </div>
            <?php endif; ?>
			<?php
			$price = BLOGINA_Course::get_price(true);
			$display_regular_price = BLOGINA_Settings::get('blg_show_regular_price');
			$display_sale_price = BLOGINA_Settings::get('blg_show_sale_price');
			?>

			<?php
			global $product;
			?>
			<div class="flex gap-x-1 w-full items-center justify-end">
				<?php if ($display_sale_price && $price['sale_price']): ?>
					<div class="text-[var(--blg-gray)] font-medium md:text-[15px] text-[13px]">
						<del><?php echo BLOGINA_Course::short_price($price['regular_price']); ?></del>
					</div>
					<?php if ($price['sale_price'] && $price['regular_price'] && $display_regular_price): ?>
						<div class="w-[1px] h-[15px] bg-[var(--blg-color-primary500)] opacity-50 mx-1"></div>
					<?php endif; ?>
					<div class="text-[var(--blg-color-secondary200)] font-medium md:text-[15px] text-[13px]"><?php echo BLOGINA_Course::short_price($price['sale_price']); ?></div>
				<?php elseif ($display_regular_price): ?>
					<div class="text-[var(--blg-color-secondary200)] font-medium md:text-[15px] text-[13px]"><?php echo BLOGINA_Course::short_price($price['regular_price']); ?></div>
				<?php endif; ?>

                <?php if ($display_regular_price || $display_sale_price): ?>
                    <?php if (!BLOGINA_Course::is_product_free($product)): ?>
                        <div class="text-[#858585] text-[14px] font-['YekanBakh']"><?php echo BLOGINA_Course::get_currency(); ?></div>
                    <?php endif; ?>
                <?php endif; ?>
			</div>
		</div>
	</div>

</article>
