<?php
$preloader_logo = BLOGINA_Settings::get('blg_preloading_logo')['url'];
$preloader_style = BLOGINA_Settings::get('blg_preloader_style', 'style1');
$loading_style = BLOGINA_Settings::get('blg_preloader_loading_style');
?>

<div id="blg-preloader-overlay" class="blg-preloader blg-preloader-<?php echo esc_attr($preloader_style); ?>"></div>
<div class="blg-preloader blg-preloader-<?php echo esc_attr($preloader_style); ?>">
    <div id="blg-preloader">
        <div class="blg-preloader-content">
            <?php if (!empty($preloader_logo)): ?>
                <img src="<?php echo esc_url($preloader_logo); ?>" alt="<?php esc_attr_e('Preloader Icon', BLOGINA_TEXT_DOMAIN); ?>">
            <?php endif; ?>

            <?php if ($loading_style === 'spinner'): ?>
                <div class="loading-spinner">
                    <div></div>
                </div>
            <?php elseif ($loading_style === 'bars'): ?>
                <div class="loading-bars">
                    <span></span><span></span><span></span><span></span>
                </div>
            <?php elseif ($loading_style === 'circle'): ?>
            <div class="loading-circle"></div>
            <?php elseif ($loading_style === 'pulse'): ?>
            <div class="loading-pulse">
                <div class="pulse"></div>
                <div class="pulse"></div>
                <div class="pulse"></div>
            </div>
            <?php elseif ($loading_style === 'dots'): ?>
            <div class="loading-dots">
                <span></span><span></span><span></span>
            </div>
            <?php elseif ($loading_style === 'multi-spinner'): ?>
                <div class="parent">
                    <div class="loading-multi-spinner"></div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

