<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINA_Course $this */

global $product;

$post_id = get_the_ID();
$thumbnail_url = get_the_post_thumbnail_url($post_id, 'full');
$gallery = BLOGINA_Course::get_gallery();
$price = BLOGINA_Course::get_price(true);
$sessions = BLOGINA_Course::get_sessions();
$view_mode = BLOGINA_Course::get_view_type();
?>
<div class="flex flex-col gap-y-4 h-full lg:order-1 order-2">
    <div class="flex gap-x-2 items-center">
                <span class="md:text-sm text-xs font-normal text-[var(--blg-gray)]">
                    <?php echo BLOGINA_Course::get_average_rating(); ?>
                </span>
        <?php echo BLOGINA_Course::get_rating(); ?>
        <div class="bg-[var(--blg-gray200)] w-[1px] h-[10px]"></div>
        <div class="flex gap-x-1 items-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="26" height="23" viewBox="0 0 26 23" fill="none">
                <path d="M19.1978 8.47908V6.79087C19.1978 5.74033 19.1978 5.21506 18.9731 4.81381C18.7755 4.46086 18.4602 4.1739 18.0724 3.99406C17.6315 3.78961 17.0543 3.78961 15.8999 3.78961H8.06742C6.91305 3.78961 6.33587 3.78961 5.89496 3.99406C5.50712 4.1739 5.1918 4.46086 4.99419 4.81381C4.76953 5.21506 4.76953 5.74033 4.76953 6.79087V16.9201L8.91109 15.0356M8.91109 15.0356C8.8919 14.7424 8.8919 14.3816 8.8919 13.9189V11.4803C8.8919 10.4298 8.8919 9.90453 9.11655 9.50328C9.31416 9.15033 9.62948 8.86337 10.0173 8.68353C10.4582 8.47908 11.0354 8.47908 12.1898 8.47908H17.9611C19.1155 8.47908 19.6927 8.47908 20.1336 8.68353C20.5214 8.86337 20.8367 9.15033 21.0343 9.50328C21.259 9.90453 21.259 10.4298 21.259 11.4803V18.7959L18.998 17.4242C18.6892 17.2368 18.5348 17.1432 18.3678 17.0768C18.2195 17.0179 18.0641 16.9751 17.9048 16.9492C17.7254 16.9201 17.5398 16.9201 17.1687 16.9201H12.1898C11.0354 16.9201 10.4582 16.9201 10.0173 16.7157C9.62948 16.5358 9.31416 16.2489 9.11655 15.8959C8.99085 15.6714 8.93548 15.4081 8.91109 15.0356Z"
                      stroke="#BEBEBE" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            </svg>
            <span class="md:text-sm text-xs font-medium text-[#676767]">
                        <?php
                        echo BLOGINA_Post::get_comment_counts($post_id) . ' دیدگاه';
                        ?>
                    </span>
        </div>
    </div>
    <div class="blg-excerpt text-justify">
        <?php echo BLOGINA_Post::get_excerpt($post_id, 95); ?>
    </div>
    <div class="blg-pricing bg-[#F1F4F7] py-5 px-6 rounded-2xl mt-2">
        <div class="flex flex-col items-center justify-end">
            <?php if ($price['sale_price']): ?>
                <div class="text-[var(--blg-gray)] font-medium md:text-[15px] text-[13px] self-end">
                    <del><?php echo $price['regular_price']; ?></del>
                </div>
                <div class="flex gap-x-2 items-center self-end">
                            <span class="text-[var(--blg-color-secondary200)] font-medium md:text-[34px] text-[25px]">
                                <?php echo $price['sale_price']; ?>
                            </span>
                    <?php if ($price['regular_price'] !== 'رایگان'): ?>
                        <div class="text-[#858585]"><?php echo BLOGINA_Course::get_currency(); ?></div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <div class="flex gap-x-2 items-center self-end">
                            <span class="text-[var(--blg-color-secondary200)] font-medium md:text-[34px] text-[25px] self-end">
                                <?php echo $price['regular_price']; ?>
                            </span>
                    <?php if ($price['regular_price'] !== 'رایگان'): ?>
                        <div class="text-[#858585]"><?php echo BLOGINA_Course::get_currency(); ?></div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="blg-gallery lg:order-2 order-1 lg:mb-0 mb-4">
    <?php if ($gallery && is_array($gallery) && count($gallery) > 0): ?>
        <div class="single-course-swiper-container !max-h-[299px]">
            <div class="swiper-wrapper">
                <?php foreach ($gallery as $image_id) : ?>
                    <div class="swiper-slide">
                        <div class="blg_course_grid">
                            <div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
                                <img loading="lazy" decoding="async" width="100%" height="100%"
                                     src="<?php echo esc_url(wp_get_attachment_url($image_id)); ?>" alt="">
                            </div>
                            <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>"
                               class="get_more">
                                <svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7"
                                     xmlns="http://www.w3.org/2000/svg" width="29" height="29" viewBox="0 0 29 29"
                                     fill="none">
                                    <path opacity="0.4"
                                          d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z"
                                          fill="#3A4654"/>
                                    <path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z"
                                          fill="#3A4654"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="xl:flex hidden gap-x-2 items-center">
                <div class="swiper-button-next">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                         fill="none">
                        <path d="M20.8 32.5H11.2C3.2 32.5 0 29.3 0 21.3V11.7C0 3.7 3.2 0.5 11.2 0.5H20.8C28.8 0.5 32 3.7 32 11.7V21.3C32 29.3 28.8 32.5 20.8 32.5Z"
                              fill="white"/>
                        <path d="M13.9837 22.148L19.6157 16.5001L13.9837 10.8521" stroke="#3A4654"
                              stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <div class="swiper-button-prev">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33"
                         fill="none">
                        <path d="M11.2 32.5H20.8C28.8 32.5 32 29.3 32 21.3V11.7C32 3.7 28.8 0.5 20.8 0.5H11.2C3.2 0.5 0 3.7 0 11.7V21.3C0 29.3 3.2 32.5 11.2 32.5Z"
                              fill="white"/>
                        <path d="M18.0163 22.148L12.3843 16.5001L18.0163 10.8521" stroke="#3A4654"
                              stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
            </div>
        </div>
    <?php else: ?>
        <?php if (has_post_thumbnail()): ?>
            <div class="blg_course_grid">
                <div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
                    <img loading="lazy" decoding="async" width="100%" height="100%"
                         src="<?php echo esc_url($thumbnail_url); ?>" alt="">
                </div>
                    <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>"
                   class="get_more">
                    <svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7" xmlns="http://www.w3.org/2000/svg"
                         width="29" height="29" viewBox="0 0 29 29" fill="none">
                        <path opacity="0.4"
                              d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z"
                              fill="#3A4654"/>
                        <path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z"
                              fill="#3A4654"/>
                    </svg>
                </a>
            </div>
        <?php else: ?>
            <div class="blg_course_grid">
                <div class="is-image bg-[var(--blg-color-primary400)] rounded-[16px]">
                    <img loading="lazy" decoding="async" width="100%" height="100%"
                         src="<?php echo get_template_directory_uri(); ?>/assets/img/default.webp" alt="">
                </div>
                <a href="<?php echo the_permalink(); ?>" target="_blank" title="<?php echo the_title(); ?>"
                   class="get_more">
                    <svg class="absolute right-[10px] top-[9px] z-50 w-7 h-7" xmlns="http://www.w3.org/2000/svg"
                         width="29" height="29" viewBox="0 0 29 29" fill="none">
                        <path opacity="0.4"
                              d="M21.7558 15.528V21.2796C21.7558 22.7613 20.6008 24.348 19.2125 24.8146L15.4908 26.0513C14.8375 26.273 13.7758 26.273 13.1341 26.0513L9.41247 24.8146C8.01247 24.348 6.86914 22.7613 6.86914 21.2796L6.88081 15.528L12.0375 18.888C13.2975 19.7163 15.3741 19.7163 16.6341 18.888L21.7558 15.528Z"
                              fill="#3A4654"/>
                        <path d="M23.6223 8.08467L16.6339 3.49967C15.3739 2.67133 13.2973 2.67133 12.0373 3.49967L5.01395 8.08467C2.76228 9.543 2.76228 12.8447 5.01395 14.3147L6.88061 15.528L12.0373 18.888C13.2973 19.7163 15.3739 19.7163 16.6339 18.888L21.7556 15.528L23.3539 14.478V18.048C23.3539 18.5263 23.7506 18.923 24.2289 18.923C24.7073 18.923 25.1039 18.5263 25.1039 18.048V12.308C25.5706 10.803 25.0923 9.053 23.6223 8.08467Z"
                              fill="#3A4654"/>
                    </svg>
                </a>
            </div>
        <?php endif; ?>
    <?php endif; ?>
    <?php BLOGINAC_Assets::footer('<style> .single-course-swiper-container { width: 100%; height: 100%; overflow: hidden; position: relative; /* Ensure arrows are positioned relative to the container */ } .swiper-wrapper { display: flex; transition-timing-function: ease; } .swiper-slide { width: 100%; flex-shrink: 0; box-sizing: border-box; } .swiper-button-next, .swiper-button-prev { color: #000; cursor: pointer; background: transparent; border: none; position: absolute; /* Position arrows */ top: 55%; /* Center vertically */ transform: translateY(-50%); /* Adjust for centering */ z-index: 999; /* Ensure arrows are above slides */ width: 32px; /* Adjust size */ height: 32px; } .swiper-button-next { right: 10px; /* Position to the right */ } .swiper-button-prev { left: 10px; /* Position to the left */ } .swiper-button-next svg, .swiper-button-prev svg { width: 100%; height: 100%; } .swiper-button-next.swiper-button-disabled svg path:first-of-type, .swiper-button-prev.swiper-button-disabled svg path:first-of-type { fill: var(--blg-color-primary500) /* Inactive color */ } .swiper-button-next.swiper-button-disabled svg path:nth-of-type(2), .swiper-button-prev.swiper-button-disabled svg path:nth-of-type(2) { stroke: #fff; /* Inactive stroke color for second path */ } </style>'); ?>
    <?php BLOGINAC_Assets::footer("<script> document.addEventListener('DOMContentLoaded', function () { var swiper = new Swiper('.single-course-swiper-container', { slidesPerView: 1, spaceBetween: 10, autoplay: true, pagination: false, navigation: { nextEl: '.swiper-button-next', prevEl: '.swiper-button-prev', }, }); }); </script>"); ?>
</div>

<?php if ($view_mode === 'slidermode'): ?>
    <div class="slider-mode-container hidden lg:order-2 order-1 lg:mb-0 mb-4 blg_course_grid"></div>
<?php endif; ?>
