<?php
/**
 * Custom Cart Errors Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/cart-errors.php.
 *
 * @package WooCommerce\Templates
 * @version 3.5.0
 */

defined( 'ABSPATH' ) || exit; ?>

<div class="flex flex-col items-center justify-center h-screen p-4 bg-gray-100">
    <h2 class="text-2xl font-bold text-red-600 mb-4"><?php esc_html_e( 'Cart Issues', 'woocommerce' ); ?></h2>
    <p class="text-lg text-gray-700 mb-6">
        <?php esc_html_e( 'There are some issues with the items in your cart. Please go back to the cart page and resolve these issues before checking out.', 'woocommerce' ); ?>
    </p>

    <?php do_action( 'woocommerce_cart_has_errors' ); ?>

    <a class="inline-block px-6 py-2 mt-4 bg-blue-600 text-white font-semibold rounded hover:bg-blue-700 transition duration-300" href="<?php echo esc_url( wc_get_cart_url() ); ?>">
        <?php esc_html_e( 'Return to Cart', 'woocommerce' ); ?>
    </a>
</div>
