<?php

/**
 * Custom Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

if (! defined('ABSPATH')) {
	exit;
}
?>

<?php do_action('woocommerce_before_checkout_form', $checkout); ?>
<?php
// If checkout registration is disabled and not logged in, the user cannot checkout.
if (! $checkout->is_registration_enabled() && $checkout->is_registration_required() && ! is_user_logged_in()) {
	echo esc_html(apply_filters('woocommerce_checkout_must_be_logged_in_message', __('You must be logged in to checkout.', 'woocommerce')));
	return;
}
?>

<form name="checkout" method="post" class="checkout woocommerce-checkout" action="<?php echo esc_url(wc_get_checkout_url()); ?>" enctype="multipart/form-data">

	<div class="blg-shadow-sm bg-white md:px-8 px-2 md:py-8 py-2 rounded-[var(--blg-radius-3xl)]">

		<div class="w-full my-2">
			<div class="flex justify-between items-center">
				<div class="flex flex-col gap-y-2">
					<h1 class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php esc_html_e('Account Details', BLOGINA_TEXT_DOMAIN); ?></h1>
					<div class="h-[1px] bg-[#E4E4E4] w-full relative">
						<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
					</div>
				</div>
			</div>
		</div>

		<?php if ($checkout->get_checkout_fields()) : ?>
			<?php do_action('woocommerce_checkout_before_customer_details'); ?>

			<div class="grid grid-cols-1 lg:grid-cols-5 gap-6 mb-6" id="customer_details">
				<div class="md:col-span-3 col-span-1">
					<?php do_action('woocommerce_checkout_billing'); ?>
				</div>

				<div class="md:col-span-2 col-span-1">
					<?php do_action('woocommerce_checkout_shipping'); ?>
				</div>
			</div>
			<?php do_action('woocommerce_checkout_after_customer_details'); ?>
		<?php endif; ?>
	</div>


	<?php do_action('woocommerce_checkout_before_order_review_heading'); ?>

	<?php do_action('woocommerce_checkout_before_order_review'); ?>

	<div id="order_review" class="woocommerce-checkout-review-order flex flex-col-reverse gap-y-10">
		<?php do_action('woocommerce_checkout_order_review'); ?>
	</div>

	<?php do_action('woocommerce_checkout_after_order_review'); ?>
</form>
<?php do_action('woocommerce_after_checkout_form', $checkout); ?>