<?php
/**
 * Email verification page.
 *
 * This displays instead of the thankyou page any time that the customer cannot be identified.
 *
 * @package WooCommerce\Templates
 * @version 7.9.0
 *
 * @var bool   $failed_submission Indicates if the last attempt to verify failed.
 * @var string $verify_url        The URL for the email verification form.
 */

defined( 'ABSPATH' ) || exit;
?>
<div class="woocommerce-verify-email max-w-lg mx-auto p-6 bg-white shadow-md rounded-lg">
    <form name="checkout" method="post" action="<?php echo esc_url( $verify_url ); ?>">

        <?php
        wp_nonce_field( 'wc_verify_email', 'check_submission' );

        if ( $failed_submission ) {
            wc_print_notice( esc_html__( 'We were unable to verify the email address you provided. Please try again.', 'woocommerce' ), 'error' );
        }
        ?>
        
        <p class="text-center mb-4">
            <?php
            printf(
                /* translators: 1: opening login link 2: closing login link */
                esc_html__( 'To view this page, you must either %1$slogin%2$s or verify the email address associated with the order.', 'woocommerce' ),
                '<a href="' . esc_url( wc_get_page_permalink( 'myaccount' ) ) . '" class="text-blue-500 hover:underline">',
                '</a>'
            );
            ?>
        </p>

        <div class="form-row mb-4">
            <label for="email" class="block text-sm font-medium text-gray-700">
                <?php esc_html_e( 'Email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span>
            </label>
            <input type="email" class="input-text mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring focus:ring-blue-200" name="email" id="email" autocomplete="email" required />
        </div>

        <div class="form-row">
            <button type="submit" class="woocommerce-button button w-full bg-blue-600 text-white py-2 rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-200">
                <?php esc_html_e( 'Verify', 'woocommerce' ); ?>
            </button>
        </div>
    </form>
</div>
