<?php

/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

$post_id = get_the_ID();
$blg_course = BLOGINA_Course::get_course_meta();

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action('woocommerce_before_single_product');

if (post_password_required()) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}
?>
<div class="flex justify-between items-center my-4 mt-12">
    <div class="flex flex-col gap-y-2">
        <?php the_title('<h1 class="text-xl font-bold text-[var(--blg-color-primary500)]">', '</h1>'); ?> </h1>
        <div class="h-[1px] bg-[#E4E4E4] w-full relative">
            <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
        </div>
    </div>
</div>

<div id="product-<?php the_ID(); ?>" <?php wc_product_class('py-6 blg-single', $product); ?>>

    <div class="bg-white blg-shadow-sm rounded-[var(--blg-radius-3xl)] overflow-hidden gap-x-8 gap-y-2 p-6 grid lg:grid-cols-2 grid-cols-1 items-center">

        <?php get_template_part('templates/single/course/image'); ?>

        <?php
        /**
         * Hook: woocommerce_before_single_product_summary.
         *
         * @hooked woocommerce_show_product_sale_flash - 10
         */
        do_action('woocommerce_before_single_product_summary');
        ?>
    </div>

    <div class="grid grid-cols-12 w-full py-10 gap-x-3">
        <?php
        /**
         * Hook: woocommerce_single_product_summary.
         *
         * @hooked woocommerce_template_single_title - 5
         * @hooked woocommerce_template_single_rating - 10
         * @hooked woocommerce_template_single_price - 10
         * @hooked woocommerce_template_single_excerpt - 20
         * @hooked woocommerce_template_single_add_to_cart - 30
         * @hooked woocommerce_template_single_meta - 40
         * @hooked woocommerce_template_single_sharing - 50
         * @hooked WC_Structured_Data::generate_product_data() - 60
         */
        //            do_action( 'woocommerce_single_product_summary' );
        ?>
        <div class="xl:col-span-9 col-span-12 w-full">
            <?php get_template_part('templates/single/course/details'); ?>

            <div class="grid grid-cols-1">
                <?php get_template_part('templates/single/course/content'); ?>
            </div>

            <?php get_template_part('templates/single/course/faq'); ?>
            <?php get_template_part('templates/single/course/sessions'); ?>

        </div>

        <?php get_template_part('templates/single/course/sidebar'); ?>

    </div>

    <?php
    /**
     * Hook: woocommerce_after_single_product_summary.
     *
     * @hooked woocommerce_output_product_data_tabs - 10
     * @hooked woocommerce_upsell_display - 15
     * @hooked woocommerce_output_related_products - 20
     */
    do_action('woocommerce_after_single_product_summary');
    ?>
</div>

<?php do_action('woocommerce_after_single_product'); ?>
