<?php
/**
 * Shop breadcrumb
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/breadcrumb.php.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     2.3.0
 * @see         woocommerce_breadcrumb()
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! empty( $breadcrumb ) ) {

    // Tailwind Classes for Breadcrumb
	$wrap_before = '<nav class="text-sm font-medium md:flex hidden items-center gap-x-2 text-gray-600 my-4" aria-label="Breadcrumb">';
	$wrap_after  = '</nav>';
	$before      = '<span class="text-balance">';
	$after       = '</span>';
	$delimiter   = '<span class="text-gray-400"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
  <path d="M10 4.51221L6 8.51221L10 12.5122" stroke="#FEC752" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
</svg></span>'; // Using / as a separator

	echo $wrap_before;

	foreach ( $breadcrumb as $key => $crumb ) {

		echo $before;

		if ( ! empty( $crumb[1] ) && sizeof( $breadcrumb ) !== $key + 1 ) {
			// Tailwind classes for links
			echo '<a href="' . esc_url( $crumb[1] ) . '" class="text-gray-400 transition-colors">' . esc_html( $crumb[0] ) . '</a>';
		} else {
			// Current item without link
			echo '<span class="text-gray-800">' . esc_html( $crumb[0] ) . '</span>';
		}

		echo $after;

		if ( sizeof( $breadcrumb ) !== $key + 1 ) {
			echo $delimiter;
		}
	}

	echo $wrap_after;

}
