<?php

/**
 * Edit account form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-edit-account.php.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.6.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_edit_account_form'); ?>

<div class="mx-auto !bg-white  p-6 blg-shadow-sm rounded-[var(--blg-radius-3xl)] my-4">

	<form class="woocommerce-EditAccountForm edit-account" action="" method="post" <?php do_action('woocommerce_edit_account_form_tag'); ?>>

		<?php do_action('woocommerce_edit_account_form_start'); ?>

		<!-- Profile Section -->
		<div class="bg-white rounded-lg p-6">
			<div class="w-full my-4">
				<div class="flex justify-between items-center">
					<div class="flex flex-col gap-y-2">
						<h2 class="md:text-xl text-md font-bold text-[var(--blg-color-primary500)]"><?php esc_html_e('Profile Details', BLOGINA_TEXT_DOMAIN); ?></h2>
						<div class="h-[1px] bg-[#E4E4E4] w-full relative">
							<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
						</div>
					</div>
				</div>
			</div>

			<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
				<div class="woocommerce-form-row woocommerce-form-row--first form-row">
					<label for="account_first_name" class="block text-sm font-medium text-gray-700"><?php esc_html_e('First name', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
					<input type="text" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring focus:ring-blue-300" name="account_first_name" id="account_first_name" autocomplete="given-name" value="<?php echo esc_attr($user ? $user->first_name : ''); ?>" />
				</div>

				<div class="woocommerce-form-row woocommerce-form-row--last form-row">
					<label for="account_last_name" class="block text-sm font-medium text-gray-700"><?php esc_html_e('Last name', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
					<input type="text" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring focus:ring-blue-300" name="account_last_name" id="account_last_name" autocomplete="family-name" value="<?php echo esc_attr($user ? $user->last_name : ''); ?>" />
				</div>

				<div class="woocommerce-form-row woocommerce-form-row--wide form-row">
					<label for="account_display_name" class="block text-sm font-medium text-gray-700"><?php esc_html_e('Display name', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
					<input type="text" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring focus:ring-blue-300" name="account_display_name" id="account_display_name" value="<?php echo esc_attr($user ? $user->display_name : ''); ?>" />
					<span class="text-sm text-gray-500"><em><?php esc_html_e('This will be how your name will be displayed in the account section and in reviews', 'woocommerce'); ?></em></span>
				</div>
			</div>

			<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
				<div class="woocommerce-form-row woocommerce-form-row--wide form-row">
					<label for="account_email" class="block text-sm font-medium text-gray-700"><?php esc_html_e('Email address', 'woocommerce'); ?>&nbsp;<span class="required">*</span></label>
					<input type="email" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring focus:ring-blue-300" name="account_email" id="account_email" autocomplete="email" value="<?php echo esc_attr($user ? $user->user_email : ''); ?>" />
				</div>
			</div>

			<?php do_action('woocommerce_edit_account_form_fields'); ?>

			<div class="w-full my-6">
				<div class="flex justify-between items-center">
					<div class="flex flex-col gap-y-2">
						<h2 class="md:text-xl text-md font-bold text-[var(--blg-color-primary500)]"><?php esc_html_e('Change Password', BLOGINA_TEXT_DOMAIN); ?></h2>
						<div class="h-[1px] bg-[#E4E4E4] w-full relative">
							<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
						</div>
					</div>
				</div>
			</div>

			<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
				<div class="woocommerce-form-row woocommerce-form-row--wide form-row">
					<label for="password_current" class="block text-sm font-medium text-gray-700"><?php esc_html_e('Current password (leave blank to leave unchanged)', 'woocommerce'); ?></label>
					<input type="password" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring focus:ring-blue-300" name="password_current" id="password_current" autocomplete="off" />
				</div>
				<div class="woocommerce-form-row woocommerce-form-row--wide form-row">
					<label for="password_1" class="block text-sm font-medium text-gray-700"><?php esc_html_e('New password (leave blank to leave unchanged)', 'woocommerce'); ?></label>
					<input type="password" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring focus:ring-blue-300" name="password_1" id="password_1" autocomplete="off" />
				</div>
				<div class="woocommerce-form-row woocommerce-form-row--wide form-row">
					<label for="password_2" class="block text-sm font-medium text-gray-700"><?php esc_html_e('Confirm new password', 'woocommerce'); ?></label>
					<input type="password" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:ring focus:ring-blue-300" name="password_2" id="password_2" autocomplete="off" />
				</div>
			</div>
			<?php
			/**
			 * My Account edit account form.
			 *
			 * @since 2.6.0
			 */
			do_action('woocommerce_edit_account_form');
			?>

			<div class="woocommerce-form-row">
				<?php wp_nonce_field('save_account_details', 'save-account-details-nonce'); ?>
				<button type="submit" class="mt-4 px-8 py-3 flex items-center text-sm font-medium rounded-md shadow-sm text-white blg-btn-secondary">
					<?php esc_html_e('Save changes', 'woocommerce'); ?>
				</button>
				<input type="hidden" name="action" value="save_account_details" />
			</div>
		</div>
		<?php do_action('woocommerce_edit_account_form_end'); ?>
	</form>
	<?php do_action('woocommerce_after_edit_account_form'); ?>
</div>
