<?php

/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

if (! defined('ABSPATH')) {
	exit;
}

do_action('woocommerce_before_account_navigation');

$assets = new BLOGINAC_Assets();
// $assets->footer('<script>
//     jQuery(document).ready(function()
//     {
//         jQuery(".blg-woo-dashboard").bloginaDashboard({
//             ajax_url: "' . admin_url('admin-ajax.php') . '",
//         });
//     });
//     </script>');
function get_account_tab_title()
{
	// Get WooCommerce endpoint
	$endpoint = WC()->query->get_current_endpoint();

	// Define titles for WooCommerce My Account tabs
	$titles = [
		''             => __('Dashboard', 'woocommerce'),
		'orders'       => __('Orders', 'woocommerce'),
		'downloads'    => __('Downloads', 'woocommerce'),
		'edit-address' => __('Addresses', 'woocommerce'),
		'payment-methods' => __('Payment Methods', 'woocommerce'),
		'edit-account' => __('Profile Details', BLOGINA_TEXT_DOMAIN),
		'customer-logout' => __('Logout', 'woocommerce'),
	];

	// Return the matching title or a default title
	return isset($titles[$endpoint]) ? $titles[$endpoint] : __('My Account', 'woocommerce');
}
?>

<header role="banner" class="entry-header">
	<div class="flex justify-between items-center my-2 mt-12">
		<div class="flex flex-col gap-y-2">
			<h1 id="dynamic-title" class="text-xl font-bold text-[var(--blg-color-primary500)]"><?php echo esc_html(get_account_tab_title()); ?></h1>
			<div class="h-[1px] bg-[#E4E4E4] w-full relative">
				<div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
			</div>
		</div>
	</div>
</header>

<div class="w-full max-w-full mx-auto px-12 py-6 bg-white blg-shadow-sm rounded-[var(--blg-radius-3xl)] my-4 overflow-hidden">
	<!-- Custom Tabs -->
	<div class="tabs flex max-sm:flex-col flex-row items-center gap-x-8 gap-y-8 w-full max-lg:overflow-hidden">
		<div class="flex gap-y-4 gap-x-4 items-center justify-center w-full min-w-max max-w-max">
			<?php echo BLOGINA_User::get_avatar(get_the_ID(), 89, 'rounded-xl', 'user'); ?>
			<div class="flex flex-col gap-y-2 w-full">
				<span class="md:text-lg text-xs font-bold text-[var(--blg-color-primary500)] whitespace-nowrap">
					<?php echo esc_html(wp_get_current_user()->display_name); ?>
				</span>
				<span class="md:text-sm text-xs font-medium text-[var(--blg-gray)] whitespace-nowrap">
					<?php echo esc_html__('User ID: ', BLOGINA_TEXT_DOMAIN) . get_current_user_id(); ?>
				</span>
			</div>
		</div>

		<div class="flex gap-x-6 items-center blg-woo-dashboard w-full xl:!max-w-[920px] relative">
			<div class="xl:flex hidden dashboard-swiper-button-next">
				<svg xmlns="http://www.w3.org/2000/svg" width="40" height="48" viewBox="0 0 49 48" fill="none">
					<path d="M31.5364 48H17.1364C5.13643 48 0.336426 43.2 0.336426 31.2V16.8C0.336426 4.8 5.13643 0 17.1364 0H31.5364C43.5364 0 48.3364 4.8 48.3364 16.8V31.2C48.3364 43.2 43.5364 48 31.5364 48Z" fill="var(--blg-color-primary500)" />
					<path d="M21.3123 32.472L29.7603 24L21.3123 15.528" stroke="var(--blg-color-primary400)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
				</svg>
			</div>
			<div class="xl:flex hidden dashboard-swiper-button-prev absolute -left-4 z-50">
				<svg xmlns="http://www.w3.org/2000/svg" width="40" height="48" viewBox="0 0 49 48" fill="none">
					<path d="M17.1364 48H31.5364C43.5364 48 48.3364 43.2 48.3364 31.2V16.8C48.3364 4.8 43.5364 0 31.5364 0H17.1364C5.13643 0 0.336426 4.8 0.336426 16.8V31.2C0.336426 43.2 5.13643 48 17.1364 48Z" fill="var(--blg-color-primary500)" />
					<path d="M27.3606 32.472L18.9126 24L27.3606 15.528" stroke="var(--blg-color-primary400)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
				</svg>
			</div>
			<div class="swiper-container w-max overflow-hidden">
				<div class="swiper-wrapper">
					<?php foreach (wc_get_account_menu_items() as $endpoint => $label) : ?>
						<?php $icon = BLOGINAC_Woocommerce::blg_get_dashboard_icons($endpoint); ?>
						<div class="!w-max swiper-slide tab-item <?php echo wc_get_account_menu_item_classes($endpoint); ?>">
							<a class="tab-link bg-[var(--blg-color-primary100)] hover:bg-[var(--blg-color-secondary200)] hover:text-white !rounded-xl px-6 py-8 w-32 flex flex-col items-center gap-y-1" href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>" <?php echo wc_is_current_account_menu_item($endpoint) ? 'aria-current="page"' : ''; ?>>
								<?php echo $icon; ?>
								<span class="py-1 text-nowrap"><?php echo esc_html($label); ?></span>
							</a>
						</div>
					<?php endforeach; ?>
				</div>
				<script>
					document.addEventListener('DOMContentLoaded', function() {
						var swiper = new Swiper('.swiper-container', {
							slidesPerView: 1,
							spaceBetween: 10,
							navigation: {
								nextEl: '.dashboard-swiper-button-next',
								prevEl: '.dashboard-swiper-button-prev',
							},
							breakpoints: {
								425: {
									slidesPerView: 1,
									spaceBetween: 15,
								},
								640: {
									slidesPerView: 2.2,
									spaceBetween: 15,
								},
								768: {
									slidesPerView: 3,
									spaceBetween: 25,
								},
								1024: {
									slidesPerView: 5,	
									spaceBetween: 45,
								},
							},
						});
					});
				</script>
			</div>
		</div>
	</div>
</div>

<?php do_action('woocommerce_after_account_navigation'); ?>