<?php
/**
 * View Order
 *
 * Shows the details of a particular order on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/view-order.php.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.0.0
 */

defined( 'ABSPATH' ) || exit;

$notes = $order->get_customer_order_notes();
?>

<div class="mx-auto !bg-white p-6 blg-shadow-sm rounded-[var(--blg-radius-3xl)] my-4">

    <p class="mb-4 text-gray-700">
        <?php
        printf(
            /* translators: 1: order number 2: order date 3: order status */
            esc_html__( 'Order #%1$s was placed on %2$s and is currently %3$s.', 'woocommerce' ),
            '<mark class="order-number font-bold">' . $order->get_order_number() . '</mark>', // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            '<mark class="order-date font-bold">' . wc_format_datetime( $order->get_date_created() ) . '</mark>', // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            '<mark class="order-status font-bold">' . wc_get_order_status_name( $order->get_status() ) . '</mark>' // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
        );
        ?>
    </p>

    <?php if ( $notes ) : ?>
        <h2 class="text-xl font-semibold mb-4"><?php esc_html_e( 'Order Updates', 'woocommerce' ); ?></h2>
        <ol class="list-decimal list-inside space-y-4">
            <?php foreach ( $notes as $note ) : ?>
                <li class="bg-gray-100 p-4 rounded-md shadow">
                    <div class="flex flex-col">
                        <p class="text-sm text-gray-600">
                            <?php echo date_i18n( esc_html__( 'l jS \o\f F Y, h:ia', 'woocommerce' ), strtotime( $note->comment_date ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                        </p>
                        <div class="mt-2">
                            <div class="woocommerce-OrderUpdate-description description">
                                <?php echo wpautop( wptexturize( $note->comment_content ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                            </div>
                        </div>
                    </div>
                </li>
            <?php endforeach; ?>
        </ol>
    <?php endif; ?>

<?php do_action( 'woocommerce_view_order', $order_id ); ?>
</div>
