<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINAC_Elementor_Category $this */

$unique_id = uniqid($this->style_option .'-');
?>
<div class="w-full blg-widget-padding-y flex items-center justify-center blg-categories-<?php echo $this->style_option; ?>">
        <div class="<?php echo $this->enable_slider ? $unique_id . 'swiper-container overflow-hidden' : 'grid xl:grid-cols-'. $this->columns .' 2xl:grid-cols-'. $this->columns .' lg:grid-cols-'. $this->columns_lg .' md:grid-cols-'. $this->columns_tablet .' grid-cols-3 !items-center !justify-center' ?>" >
            <?php echo $this->enable_slider ? '<div class="swiper-wrapper">': ''; ?>

            <?php foreach ($this->category_list as $category): ?>
                <?php $target = $category['category_link']['is_external'] ? ' target="_blank"' : ''; $nofollow = $category['category_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
                <a href="<?php echo esc_url($category['category_link']['url']); ?>" <?php echo $target . $nofollow; ?>
                   class="<?php echo $this->enable_slider ? 'swiper-slide': ''; ?> !m-0 flex md:items-center md:justify-center hover:text-white transition-all duration-200 md:rounded-[var(--blg-radius-3xl)] rounded-[16px] blg-shadow-sm px-1">
                    <svg class="hexagon-svg hover:fill-[var(--blg-color-secondary200)]" viewBox="0 0 110.74 123.18">
                        <path d="M307.58,232.84l-40.2-23.21a14.17,14.17,0,0,1-7.09-12.27V150.94a14.17,14.17,0,0,1,7.09-12.27l40.2-23.21a14.17,14.17,0,0,1,14.17,0L362,138.67A14.17,14.17,0,0,1,369,150.94v46.42A14.17,14.17,0,0,1,362,209.63l-40.2,23.21A14.17,14.17,0,0,1,307.58,232.84Z" transform="translate(-259.29 -112.56)"></path>
                        <foreignObject x="0" y="0" width="100%" height="100%">
                            <div class="flex flex-col items-center justify-center w-full h-full gap-2" xmlns="http://www.w3.org/1999/xhtml">
                                <div class="category-icon-wrapper">
                                    <?php \Elementor\Icons_Manager::render_icon($category['category_icon'], ['aria-hidden' => 'true', 'class' => 'category-icon md:w-7 md:h-auto w-7 h-7']); ?>
                                </div>
                                <span class="md:text-md font-['Pinar'] text-[15px] font-medium category-name"><?php echo esc_html($category['category_name']); ?></span>
                            </div>
                        </foreignObject>
                    </svg>
                </a>
            <?php endforeach; ?>
            <?php echo $this->enable_slider ? '</div>' : '';?>
            <?php if($this->enable_slider && $this->show_pagination) : ?>
                <div class="category-<?php echo esc_attr($unique_id); ?>-pagination flex items-center justify-center pt-8 blg-swiper-pagination"></div>
            <?php endif; ?>
        </div>
    </div>

<?php if($this->enable_slider): ?>
    <script>
        new Swiper('.<?php echo esc_attr($unique_id); ?>swiper-container', {
            loop: <?php echo esc_attr($this->enable_loop); ?>,
            pagination: {
                el: '.category-<?php echo esc_attr($unique_id); ?>-pagination',
                clickable: true,
            },
            slidesPerView: 3,
            spaceBetween: 10,
            <?php if (!$this->enable_autoplay): ?>
            autoplay: false,
            <?php else: ?>
            autoplay: {
                delay: <?php echo esc_attr($this->autoplay_delay) ?? 0; ?>,
                disableOnInteraction: true,
                pauseOnMouseEnter: true,
            },
            <?php endif; ?>
            breakpoints: {
                768: { slidesPerView: <?php echo esc_attr($this->columns_tablet); ?> },
                1024: { slidesPerView: <?php echo esc_attr($this->columns_lg); ?> },
                1025: {slidesPerView: <?php echo esc_attr($this->columns); ?>}
            },
        });
    </script>
<?php endif; ?>
