<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINAC_Elementor_Comments $this */
$args = [
    'number' => $this->number_of_comments,
    'status' => 'approve',
];

$comments = get_comments($args);

// No Comments Found
if (empty($comments)) return;

$unique_id = uniqid('blg-comments-');
?>
<div class="blg-widget-padding-y mx-auto lg:py-20 py-8 blg-comments-widget">
    <div class="blg-comments-section bg-[var(--blg-color-primary500)] w-full overflow-hidden !rounded-[var(--blg-radius-3xl)] xl:py-10 py-8 xl:px-20 px-4 flex flex-col <?php echo $this->show_title ? 'gap-y-8': ''; ?> items-center justify-center">
        <div class="flex justify-between items-center w-full relative">
            <?php if($this->show_title): ?>
                <div class="flex flex-col gap-y-2 comments-post-title">
                <h3 class="text-xl font-bold text-white"><?php echo esc_html($this->section_title); ?></h3>
                <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                    <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px] blg-title-underline"></div>
                </div>
            </div>
            <?php endif; ?>
            <?php if($this->enable_slider && $this->show_navigation): ?>
                <div class="md:flex md:!ml-[10px] hidden gap-x-1 items-center justify-center">
                    <div class="comment-<?php echo esc_attr($unique_id); ?>-button-prev">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33" fill="none">
                            <path d="M20.8 32.5H11.2C3.2 32.5 0 29.3 0 21.3V11.7C0 3.7 3.2 0.5 11.2 0.5H20.8C28.8 0.5 32 3.7 32 11.7V21.3C32 29.3 28.8 32.5 20.8 32.5Z"
                                  fill="white"/>
                            <path d="M13.9837 22.148L19.6157 16.5001L13.9837 10.8521" stroke="var(--blg-color-primary500)"
                                  stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div class="comment-<?php echo esc_attr($unique_id); ?>-button-next">
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33" fill="none">
                            <path d="M11.2 32.5H20.8C28.8 32.5 32 29.3 32 21.3V11.7C32 3.7 28.8 0.5 20.8 0.5H11.2C3.2 0.5 0 3.7 0 11.7V21.3C0 29.3 3.2 32.5 11.2 32.5Z"
                                  fill="white"/>
                            <path d="M18.0163 22.148L12.3843 16.5001L18.0163 10.8521" stroke="var(--blg-color-primary500)"
                                  stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <div class="grid grid-cols-1 items-center lg:gap-x-6 gap-x-0 lg:gap-y-0 gap-y-6 w-full">
            <div class=" <?php echo $this->enable_slider ? $unique_id . 'swiper-container relative' : 'grid xl:grid-cols-'. $this->columns .' md:grid-cols-'. $this->columns_tablet .' grid-cols-1 gap-y-6 gap-x-6'; ?> w-full md:h-auto h-full overflow-x-hidden overflow-y-hidden px-[10px] py-5">
                <?php echo $this->enable_slider ? '<div class="swiper-wrapper style="overflow:visible !important;">' : ''; ?>
                    <?php foreach ($comments as $comment): ?>
                        <div style="overflow:visible !important;"
                             class="<?php echo $this->enable_slider ? 'swiper-slide': ''; ?> blg-comments-items flex items-start justify-center text-[18px] w-full relative blg-shadow-sm flex-col gap-y-5 !rounded-[var(--blg-radius-3xl)] bg-white py-8 px-6 hover:!border-t-2 hover:!border-t-[var(--blg-color-secondary200)] !transition-all !duration-75 min-h-[147px]">
                            <div class="flex items-center gap-x-4">
                                <div class="flex flex-col gap-y-2 !rounded-[var(--blg-radius-md)] text-nowrap">
                                    <?php if ($comment->comment_author_email): ?>
                                        <img width="60px" height="100%" class="!rounded-[var(--blg-radius-md)]"
                                             src="<?php echo esc_url(get_avatar_url($comment)); ?>" alt="user-avatar">
                                    <?php endif; ?>
                                    <span class="text-[var(--blg-color-primary500)] font-bold lg:text-base text-[15px] blg-comment-author"><?php echo esc_html($comment->comment_author); ?></span>
                                </div>
                                <span class="lg:text-[15px] text-sm font-normal text-[#727272] text-justify blg-comment-desc">
                                        <?php
                                        $max_length = 20;
                                        $comment_content = wp_trim_words($comment->comment_content, $max_length, '...');
                                        echo esc_html($comment_content);
                                        ?>
                                </span>

                            </div>
                            <div class="absolute -bottom-3 left-6">
                                <svg class="blg-comment-icon max-lg:w-[39px] max-lg:h-[26px]"
                                     xmlns="http://www.w3.org/2000/svg"
                                     width="59" height="40" viewBox="0 0 59 40" fill="none">
                                    <g clip-path="url(#clip0_272_2510)">
                                        <path d="M34.7209 36.8743C37.4069 35.6151 44.9818 31.0225 46.8227 22.4002H38.2821C36.5317 22.4002 35.1284 21.0076 35.1284 19.3039V4.81505C35.1284 3.09653 36.5468 1.71875 38.2821 1.71875H53.0396C54.79 1.71875 56.1933 3.11135 56.1933 4.81505V14.3113C55.9821 31.9262 41.0434 38.3262 35.9734 39.9854C35.068 40.2817 34.1023 39.7928 33.8156 38.9039L33.8005 38.8743C33.5741 38.0891 33.9514 37.2299 34.7209 36.8743Z"
                                              fill="var(--blg-color-primary400)"/>
                                        <path d="M2.74633 36.8743C5.43227 35.6151 13.0072 31.0225 14.8481 22.4002H6.30745C4.55707 22.4002 3.15375 21.0076 3.15375 19.3039V4.81505C3.15375 3.09653 4.57216 1.71875 6.30745 1.71875H21.065C22.8154 1.71875 24.2187 3.11135 24.2187 4.81505V14.3113C24.0075 31.9262 9.06884 38.3262 3.99876 39.9854C3.09339 40.2817 2.12766 39.7928 1.84096 38.9039L1.82587 38.8743C1.59952 38.0891 1.97677 37.2299 2.74633 36.8743Z"
                                              fill="var(--blg-color-primary400)"/>
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_272_2510">
                                            <rect width="59" height="40" fill="white"/>
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php echo $this->enable_slider ? '</div>' : '';?>
                <?php if($this->enable_slider && $this->show_pagination) : ?>
                    <div class="comment-<?php echo esc_attr($unique_id); ?>-pagination flex items-center justify-center pt-12 !relative blg-swiper-pagination"></div>
                <?php endif; ?>
            </div>
        </div>

        <div class="lg:hidden flex">
            <button aria-label="view all" class="blg-btn-secondary"><?php esc_html_e('view all', BLOGINAC_TEXT_DOMAIN); ?></button>
        </div>
    </div>
</div>

<?php if($this->enable_slider): ?>
    <script>
        new Swiper('.<?php echo esc_attr($unique_id); ?>swiper-container', {
            loop: <?php echo esc_attr($this->enable_loop); ?>,
            navigation: {
                nextEl: '.comment-<?php echo esc_attr($unique_id); ?>-button-next',
                prevEl: '.comment-<?php echo esc_attr($unique_id); ?>-button-prev',
            },
            pagination: {
                el: '.comment-<?php echo esc_attr($unique_id); ?>-pagination',
                clickable: true,
            },
            slidesPerView: 1,
            spaceBetween: 20,
            <?php if (!$this->enable_autoplay): ?>
            autoplay: false,
            <?php else: ?>
            autoplay: {
                delay: <?php echo esc_attr($this->autoplay_delay) ?? 0; ?>,
                disableOnInteraction: true,
            },
            <?php endif; ?>
            breakpoints: {
                768: { slidesPerView: <?php echo esc_attr($this->columns_tablet); ?> },
                1024: { slidesPerView: <?php echo esc_attr($this->columns); ?> },
            },
        });
    </script>
<?php endif; ?>
