<?php
// no direct access
defined('ABSPATH') || die();

// Apply filters to get the list of tab keys
$tabs = apply_filters('blg_course_admin_tabs', [
    'features',
    'course',
    'sessions',
    'tutor',
    'cqa',
]);

?>
<div class="blg-tab-content-wrapper">
    <?php foreach ($tabs as $key): ?>
        <div id="tab-<?php echo esc_attr($key); ?>" class="blg-tab-content <?php echo $key === 'features' ? 'active' : ''; ?>" data-content="<?php echo esc_attr($key); ?>">
            <?php $this->include_html_file("metaboxes/course/tabs/{$key}.php"); ?>
        </div>
    <?php endforeach; ?>
</div>

<style>
    .blg-tab-content { display: none; }
    .blg-tab-content.active { display: block; }
</style>

