<?php
// no direct access
defined('ABSPATH') || die();

/** @var WP_Post $post */
global $post;

// Retrieve 'blg' meta key
$blg = get_post_meta($post->ID, 'blg-course', true);
$blg = is_array($blg) ? $blg : []; // Ensure $blg is an array

// Extract chapters and their sessions
$chapters = isset($blg['chapters']) ? $blg['chapters'] : [];
?>

<div class="blg-metabox">
    <div class="blg-chapters">
        <div class="blg-chapters-button">
            <label for="blg_chapters" class="blg-price-label blg-col-12"><?php esc_html_e('Chapters and Sessions', BLOGINAC_TEXT_DOMAIN); ?></label>
            <button type="button" id="blg_add_chapter" class="blg-button mt-4"><?php esc_html_e('Add Chapter', BLOGINAC_TEXT_DOMAIN); ?></button>
        </div>

        <div class="blg-chapter-container" id="blg_chapter_container">
            <?php foreach ($chapters as $chapterIndex => $chapter) : ?>
                <div class="blg-chapter">
                    <div class="blg-sessions" id="blg_session_container_<?php echo esc_attr($chapterIndex); ?>">
                        <div class="blg-chapter-title">
                            <?php echo BLOGINAC_Form::text([
                                'name'          => "blg[chapters][" . esc_attr($chapterIndex) . "][title]",
                                'placeholder'   =>  esc_html__('Chapter Title', BLOGINAC_TEXT_DOMAIN),
                                'value'         =>  esc_attr($chapter['title']),
                                'class'         => 'w-full p-2 border border-[var(--blg-color-primary400)] rounded',
                            ]); ?>

                            <?php
                            echo BLOGINAC_Form::submit([
                                'class' => 'blg-remove-chapter blg-button',
                                'label' => '',
                                'icon' => '<i class="fa fa-trash" aria-hidden="true"></i>',
                            ], 'button')
                            ?>
                            <?php
                            echo BLOGINAC_Form::submit([
                                'class' => 'blg_add_session blg-button mt-2',
                                'label' => '',
                                'icon' => '<i class="fa fa-plus" aria-hidden="true"></i>',
                                'attributes' => [
                                    'data-chapter-index' => esc_attr($chapterIndex),
                                ]
                            ], 'button')
                            ?>
                            <?php
                            echo BLOGINAC_Form::submit([
                                'class' => 'blg-toggle-sessions blg-button mt-2',
                                'label' => '',
                                'icon' => '<i class="fa fa-chevron-down" aria-hidden="true"></i>',
                                'attributes' => [
                                    'data-toggle-target' => '#blg_session_container_' . esc_attr($chapterIndex),
                                ]
                            ], 'button')
                            ?>
                        </div>

                        <?php if (!empty($chapter['sessions'])) : ?>
                            <?php foreach ($chapter['sessions'] as $sessionIndex => $session) : ?>
                                <div class="blg-session" style="display: none;">
                                    <?php echo BLOGINAC_Form::text([
                                        'name'          => "blg[chapters][" . esc_attr($chapterIndex) . "][sessions][" . esc_attr($sessionIndex) . "][title]",
                                        'placeholder'   =>  esc_html__('Session Title', BLOGINAC_TEXT_DOMAIN),
                                        'value'         =>  esc_attr($session['title']),
                                        'class'         => 'w-full p-2 border border-[var(--blg-color-primary400)] rounded',
                                    ]);
                                    ?>
                                    <div class="blg-session-title">

                                        <?php
                                        echo BLOGINAC_Form::select([
                                            'name' => 'blg[chapters][' . esc_attr($chapterIndex) . '][sessions][' . esc_attr($sessionIndex) . '][status]',
                                            'class' => 'w-full p-2 border border-[var(--blg-color-primary400)] rounded mt-2',
                                            'options' => [
                                                'locked' => __('Locked', BLOGINAC_TEXT_DOMAIN),
                                                'free' => __('Free', BLOGINAC_TEXT_DOMAIN),
                                            ],
                                            'value' => isset($session['status']) ? $session['status'] : '',
                                        ]);
                                        ?>

                                        <?php
                                        echo BLOGINAC_Form::submit([
                                            'class' => 'blg-remove-session blg-button',
                                            'label' => '',
                                            'icon' => '<i class="fa fa-trash" aria-hidden="true"></i>',
                                        ], 'button')
                                        ?>
                                    </div>
                                    <?php echo BLOGINAC_Form::url([
                                        'name'          => "blg[chapters][" . esc_attr($chapterIndex) . "][sessions][" . esc_attr($sessionIndex) . "][url]",
                                        'value'         =>  esc_attr($session['url']),
                                        'class'         => 'w-full p-2 border border-[var(--blg-color-primary400)] rounded',
                                        'placeholder'   =>  esc_html__('Session URL', BLOGINAC_TEXT_DOMAIN),
                                    ]);
                                    ?>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>


<script>
    jQuery(document).ready(function($) {
        let chapterIndex = <?php echo count($chapters); ?>;

        // Add new chapter
        $('#blg_add_chapter').on('click', function() {
            const chapterContainer = $('<div>', {
                class: 'blg-chapter'
            });
            const chapterTitle = $('<div>', {
                class: 'blg-chapter-title'
            });

            chapterTitle.append(createInput('text', `blg[chapters][${chapterIndex}][title]`, '<?php esc_attr_e('Chapter Title', BLOGINAC_TEXT_DOMAIN); ?>', 'w-full p-2 border border-[var(--blg-color-primary400)] rounded', true));
            chapterTitle.append(createButton('button', 'blg-remove-chapter blg-button', '<i class="fa fa-trash" aria-hidden="true"></i>'));
            chapterTitle.append(createButton('button', 'blg_add_session blg-button mt-2', '<i class="fa fa-plus" aria-hidden="true"></i>', {
                'data-chapter-index': chapterIndex
            }));

            chapterContainer.append(chapterTitle);
            chapterContainer.append($('<div>', {
                class: 'blg-sessions',
                id: `blg_session_container_${chapterIndex}`
            }));
            $('#blg_chapter_container').append(chapterContainer);

            chapterIndex++;
        });

        // Remove chapter
        $(document).on('click', '.blg-remove-chapter', function() {
            $(this).closest('.blg-chapter').remove();
        });

        // Add new session
        $(document).on('click', '.blg_add_session', function() {
            const currentChapterIndex = $(this).data('chapter-index');
            const sessionContainer = $(`#blg_session_container_${currentChapterIndex}`);
            const sessionIndex = sessionContainer.children('.blg-session').length;

            const sessionElement = $('<div>', {
                class: 'blg-session'
            });
            const sessionTitle = $('<div>', {
                class: 'blg-session-title'
            });

            sessionElement.append(createInput('text', `blg[chapters][${currentChapterIndex}][sessions][${sessionIndex}][title]`, '<?php esc_attr_e('Session Title', BLOGINAC_TEXT_DOMAIN); ?>', 'w-full p-2 border border-[var(--blg-color-primary400)] rounded'));
            sessionTitle.append(createSelect(
                `blg[chapters][${currentChapterIndex}][sessions][${sessionIndex}][status]`, {
                    locked: '<?php esc_html_e('Locked', BLOGINAC_TEXT_DOMAIN); ?>',
                    free: '<?php esc_html_e('Free', BLOGINAC_TEXT_DOMAIN); ?>'
                },
                'w-full p-2 border border-[var(--blg-color-primary400)] rounded mt-2'
            ));
            sessionTitle.append(createButton('button', 'blg-remove-session blg-button', '<i class="fa fa-trash" aria-hidden="true"></i>'));

            sessionElement.append(sessionTitle);
            sessionElement.append(createInput('url', `blg[chapters][${currentChapterIndex}][sessions][${sessionIndex}][url]`, '<?php esc_attr_e('Session URL', BLOGINAC_TEXT_DOMAIN); ?>', 'w-full p-2 border border-[var(--blg-color-primary400)] rounded'));

            sessionContainer.append(sessionElement);
        });

        $('#blg_chapter_container .blg-session').hide();
        $('#blg_chapter_container .blg-chapter:first-child .blg-session').show();
        $('#blg_chapter_container .blg-chapter:first-child .blg-toggle-sessions i').removeClass('fa-chevron-down').addClass('fa-chevron-up');
        // Remove session
        $(document).on('click', '.blg-remove-session', function() {
            $(this).closest('.blg-session').remove();
        });

        // Toggle sessions
        $(document).on('click', '.blg-toggle-sessions', function() {
            const target = $(this).data('toggle-target');
            const icon = $(this).find('i');
            $('.blg-session').hide();
            $('.blg-toggle-sessions i').removeClass('fa-chevron-up').addClass('fa-chevron-down');

            $(target).find('.blg-session').toggle();
            icon.toggleClass('fa-chevron-down fa-chevron-up');
        });
    });
</script>
