<?php
// no direct access
defined('ABSPATH') || die();

/** @var BLOGINAC_Woocommerce $this */

$order_items = $order->get_items();

$subtotal = $order->get_subtotal();
$shipping_total = $order->get_shipping_total();
$total = $order->get_total();
$payment_method = $order->get_payment_method_title();
$discount_total = $order->get_discount_total(); // Get total discount amount

$billing_address = $this->get_billing_address_output($order);
$shipping_address = $this->get_shipping_address_output($order);

?>

<div class="py-2">
    <span class="text-base font-medium my-4 flex lg:flex-row flex-col text-[var(--blg-gray)]"><?php esc_html_e('Order details', 'woocommerce') ?></span>

    <!-- Order Items Section -->
    <div class="mb-4 text-[var(--blg-color-primary500)] grid grid-cols-2 gap-4">
        <span class="font-bold"><?php esc_html_e('Product', 'woocommerce'); ?></span>
        <span class="font-bold"><?php esc_html_e('Total', 'woocommerce'); ?></span>
    </div>

    <div class="order-items w-full mb-4 text-[var(--blg-color-primary500)]">
        <?php foreach ($order_items as $item_id => $item): ?>
            <div class="order-item font-semibold md:text-base text-sm grid grid-cols-2 justify-between items-center bg-[var(--blg-color-primary100)] mb-2 py-4 px-6 rounded-lg">
                <span class="item-name text-right"><?php echo esc_html($item->get_name()) . ' × ' . esc_html($item->get_quantity()); ?></span>
                <span class="item-total text-right md:text-xl text-base"><?php echo wc_price($item->get_total()); ?></span>
            </div>
        <?php endforeach; ?>
    </div>

    <div class="order-totals mb-4 flex flex-col !gap-y-4 text-[var(--blg-color-primary500)] px-6">
        <p class="total-line grid grid-cols-2 items-center justify-between text-right font-bold md:text-base text-sm">
            <span><?php esc_html_e('Cart totals', 'woocommerce'); ?></span>
            <span class="md:text-xl text-base"><?php echo wc_price($subtotal); ?></span>
        </p>

        <?php if ($discount_total > 0): ?>
            <p class="total-line grid grid-cols-2 items-center justify-between text-right font-bold md:text-base text-sm">
                <span><?php esc_html_e('Discount:', 'woocommerce'); ?></span>
                <span class="md:text-xl text-base">-<?php echo wc_price($discount_total); ?></span>
            </p>
        <?php endif; ?>

        <p class="total-line grid grid-cols-2 items-center justify-between text-right font-bold md:text-base text-sm">
            <span><?php esc_html_e('Shipping:', 'woocommerce'); ?></span>
            <span class="md:text-xl text-base"><?php echo wc_price($shipping_total); ?></span>
        </p>
        <p class="total-line grid grid-cols-2 items-center justify-between text-right font-bold md:text-base text-sm">
            <span><?php esc_html_e('Payment method:', 'woocommerce'); ?></span>
            <span class="md:text-xl text-base"><?php echo esc_html($payment_method); ?></span>
        </p>
        <p class="total-line grid grid-cols-2 items-center justify-between text-right font-bold md:text-base text-sm">
            <span><?php esc_html_e('Total:', 'woocommerce'); ?></span>
            <span class="md:text-xl text-base"><?php echo wc_price($total); ?></span>
        </p>
    </div>

    <!-- Billing Address Section -->
    <?php if (!empty($billing_address)): ?>
        <div class="w-full h-[1px] bg-[var(--blg-color-primary500)] opacity-10 my-10"></div>
        <div class="w-full">
            <div class="flex justify-between items-center">
                <div class="flex flex-col gap-y-2">
                    <h3 class="md:text-xl text-md font-bold text-[var(--blg-color-primary500)]"><?php esc_html_e('Billing Address', 'woocommerce'); ?></h3>
                    <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                        <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                    </div>
                </div>
            </div>

            <!-- Billing Address Content -->
            <div class="text-right mt-5 flex items-center gap-x-4 p-4 bg-[var(--blg-color-primary100)] rounded-2xl">
                <div class="bg-[var(--blg-color-primary500)] p-5 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
                        <path opacity="0.4" d="M34.5729 14.598C32.8229 6.898 26.1062 3.43134 20.2062 3.43134C20.2062 3.43134 20.2062 3.43134 20.1895 3.43134C14.3062 3.43134 7.57288 6.88134 5.82288 14.5813C3.87288 23.1813 9.13955 30.4647 13.9062 35.048C15.6729 36.748 17.9395 37.598 20.2062 37.598C22.4729 37.598 24.7395 36.748 26.4895 35.048C31.2562 30.4647 36.5229 23.198 34.5729 14.598Z" fill="white" />
                        <path d="M20.207 22.948C23.1065 22.948 25.457 20.5975 25.457 17.698C25.457 14.7985 23.1065 12.448 20.207 12.448C17.3075 12.448 14.957 14.7985 14.957 17.698C14.957 20.5975 17.3075 22.948 20.207 22.948Z" fill="white" />
                    </svg>
                </div>
                <div class="md:text-[15px] text-sm font-normal text-[var(--blg-gray)]">
                    <?php echo esc_html($billing_address); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (!empty($shipping_address)): ?>
        <div class="w-full h-[1px] bg-[var(--blg-color-primary500)] opacity-10 my-10"></div>
        <div class="w-full mb-6 mt-10">
            <div class="flex justify-between items-center">
                <div class="flex flex-col gap-y-2">
                    <h3 class="md:text-xl text-md font-bold text-[var(--blg-color-primary500)]"><?php esc_html_e('Shipping Address', 'woocommerce'); ?></h3>
                    <div class="h-[1px] bg-[#E4E4E4] w-full relative">
                        <div class="h-[3px] rounded-[var(--blg-radius-lg)] bg-[var(--blg-color-secondary200)] absolute w-1/3 right-[32%] top-[-1px]"></div>
                    </div>
                </div>
            </div>
            <div class="text-right mt-5 flex items-center gap-x-4 p-4 bg-[var(--blg-color-primary100)] rounded-2xl">
                <div class="bg-[var(--blg-color-primary500)] p-5 rounded-lg">
                    <svg xmlns="http://www.w3.org/2000/svg" width="41" height="41" viewBox="0 0 41 41" fill="none">
                        <path opacity="0.4" d="M34.5729 14.598C32.8229 6.898 26.1062 3.43134 20.2062 3.43134C20.2062 3.43134 20.2062 3.43134 20.1895 3.43134C14.3062 3.43134 7.57288 6.88134 5.82288 14.5813C3.87288 23.1813 9.13955 30.4647 13.9062 35.048C15.6729 36.748 17.9395 37.598 20.2062 37.598C22.4729 37.598 24.7395 36.748 26.4895 35.048C31.2562 30.4647 36.5229 23.198 34.5729 14.598Z" fill="white" />
                        <path d="M20.207 22.948C23.1065 22.948 25.457 20.5975 25.457 17.698C25.457 14.7985 23.1065 12.448 20.207 12.448C17.3075 12.448 14.957 14.7985 14.957 17.698C14.957 20.5975 17.3075 22.948 20.207 22.948Z" fill="white" />
                    </svg>
                </div>
                <div class="md:text-[15px] text-sm font-normal text-[var(--blg-gray)]">
                    <?php echo esc_html($shipping_address); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
