<?php
// Prevent direct access
defined('ABSPATH') || die();

/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Blog_Filters extends BLOGINAC_Elementor_Posts
{
    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Adding a new style section for Title and Card styling
        $this->start_controls_section(
            'section_blog_filter_button_styles',
            [
                'label' => __('Filter Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'style_option' => 'style1',
                ],
            ]
        );

        // Option to Hide/Show Filters
        $this->add_control(
            'show_filters',
            [
                'label' => __('Show Filters', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'default' => 'yes',
            ]
        );

        // Title Typography Control
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'filter_title_typography',
                'label' => __('Title Typography', BLOGINAC_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .blog-post-filter-title span',
                'condition' => [
                    'style_option' => 'style1',
                    'show_filters' => 'yes'
                ],
            ]
        );

        // Title Color Control
        $this->add_control(
            'filter_title_color',
            [
                'label' => __('Title Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-post-filter-title span' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'style_option' => 'style1',
                    'show_filters' => 'yes'
                ],
            ]
        );

        // Icon Color Control
        $this->add_control(
            'filter_icon_color',
            [
                'label' => __('Filter Icon Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .blog-post-filter-title svg circle' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'style_option' => 'style1',
                    'show_filters' => 'yes'
                ],
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
