<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Category_Settings extends BLOGINAC_Elementor_Category
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Category Section
        $this->start_controls_section(
            'category_section',
            [
                'label' => __('Settings', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'style_option',
            [
                'label' => __('Style Option', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style1' => __('Style 1', BLOGINAC_TEXT_DOMAIN),
                    'style2' => __('Style 2', BLOGINAC_TEXT_DOMAIN),
                ],
                'default' => 'style1',
            ]
        );


        // Repeater for multiple categories
        $repeater = new \Elementor\Repeater();

        // Category name
        $repeater->add_control(
            'category_name',
            [
                'label' => __('Category Name', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Economy', BLOGINAC_TEXT_DOMAIN),
                'label_block' => true,
            ]
        );

        // Category Icon
        $repeater->add_control(
            'category_icon',
            [
                'label' => __('Category Icon', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-coins',
                    'library' => 'solid',
                ],
            ]
        );

        // Category Link
        $repeater->add_control(
            'category_link',
            [
                'label' => __('Category Link', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', BLOGINAC_TEXT_DOMAIN),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
            ]
        );

        $this->add_control(
            'categories_list',
            [
                'label' => __('Categories', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ category_name }}}',
                'default' => [
                    ['category_name' => __('Economy', BLOGINAC_TEXT_DOMAIN)],
                    ['category_name' => __('Technology', BLOGINAC_TEXT_DOMAIN)],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_section',
            [
                'label' => __('Slider', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'enable_sliders',
            [
                'label' => __('Enable slider', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'enable_autoplay',
            [
                'label' => __('Autoplay', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'autoplay_delay',
            [
                'label' => __('AutoPlay Delay (ms)', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1000,
                'max' => 10000,
                'step' => 100,
                'default' => 2000,
                'condition' => [
                    'enable_autoplay' => 'yes',
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'enable_loop',
            [
                'label' => __('Loop', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => __('Show Pagination', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'columns_section',
            [
                'label' => __('Columns', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'columns_desktop',
            [
                'label' => __('Desktop Columns', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => $this->style_option == 'style2' ? 9 : 6,
                'min' => 1,
                'max' => 12,
                'step' => 1,
            ]
        );

        $this->add_control(
            'columns_lg',
            [
                'label' => __('LG Columns', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3,
                'min' => 1,
                'max' => 12,
                'step' => 1,
                'description' => __('Select the number of columns for large screen (1024px above)', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'columns_tablet',
            [
                'label' => __('Tablet Columns', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3,
                'min' => 1,
                'max' => 12,
                'step' => 1,
                'description' => __('Select the number of columns for tablet (768px to 1024px) ', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
