<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Comments_Box extends BLOGINAC_Elementor_Comments
{
    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Adding a new style section for Title and Card styling
        $this->start_controls_section(
            'section_comment_box_styles',
            [
                'label' => __('Box Styling', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Card Background Color Control
        $this->add_control(
            'comments_box_bg_color',
            [
                'label' => __('Section Background Color', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'var(--blg-color-primary500)',
                'selectors' => [
                    '{{WRAPPER}} .blg-comments-section' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __('Inner Box Padding', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .blg-comments-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'outer_box_padding',
            [
                'label' => __('Outer Box Padding', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .blg-comments-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        // End Section
        $this->end_controls_section();
    }
}
