<?php
// Prevent direct access
defined('ABSPATH') || die();


/**
 * Plugin Elementor Base Class.
 *
 * @class BLOGINAC_Elementor_Base
 * @version 1.0.0
 */
class BLOGINAC_Controls_Comments_Settings extends BLOGINAC_Elementor_Comments
{

    /**
     * Add title style controls
     */
    public function register_controls()
    {
        // Content Section
        $this->start_controls_section(
            'bloginac_content_section',
            [
                'label' => __('Content', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_title',
            [
                'label' => __('Show Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // Title Control
        $this->add_control(
            'section_title',
            [
                'label' => __('Section Title', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Your Comment', BLOGINAC_TEXT_DOMAIN),
                'placeholder' => __('Enter your title', BLOGINAC_TEXT_DOMAIN),
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        // Number of Comments to Display
        $this->add_control(
            'number_of_comments',
            [
                'label' => __('Number of Comments', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5,
                'min' => 1,
                'max' => 20,
                'step' => 1,
            ]
        );

        // End Section
        $this->end_controls_section();

        $this->start_controls_section(
            'comments_slider_section',
            [
                'label' => __('Slider', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'enable_sliders',
            [
                'label' => __('Enable slider', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'enable_autoplay',
            [
                'label' => __('Autoplay', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'autoplay_delay',
            [
                'label' => __('AutoPlay Delay (ms)', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1000,
                'max' => 10000,
                'step' => 100,
                'default' => 2000,
                'condition' => [
                    'enable_autoplay' => 'yes',
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'enable_loop',
            [
                'label' => __('Loop', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => __('Show Pagination', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_navigation',
            [
                'label' => __('Show Navigations', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', BLOGINAC_TEXT_DOMAIN),
                'label_off' => __('No', BLOGINAC_TEXT_DOMAIN),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'enable_sliders' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'comments_columns_section',
            [
                'label' => __('Columns', BLOGINAC_TEXT_DOMAIN),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'columns_desktop',
            [
                'label' => __('Desktop Columns', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 2,
                'min' => 1,
                'max' => 3,
                'step' => 1,
            ]
        );

        $this->add_control(
            'columns_tablet',
            [
                'label' => __('Tablet Columns', BLOGINAC_TEXT_DOMAIN),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 2,
                'min' => 1,
                'max' => 2,
                'step' => 1,
                'description' => __('Select the number of columns for tablet (768px to 1024px) ', BLOGINAC_TEXT_DOMAIN),
            ]
        );

        // End Section
        $this->end_controls_section();
    }
}
